<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;

class Campus extends Model implements Auditable
{
    protected $table = 'sedes';

    use HasFactory, \OwenIt\Auditing\Auditable;

    static $rules = [

        'tipo_sede' => 'required',
        'codigo' => 'required',
        'nombre' => 'required',
        'nombre_corto' => 'required',
        'direccion' => 'required',
        'telefono' => 'required',
        'correo' => 'required',
        'nombre_representante' => 'required',
        'horas_servicio' => 'required',

    ];

    protected $perPage = 20;

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'tipo_sede',
        'codigo',
        'nombre',
        'nombre_corto',
        'direccion',
        'telefono',
        'correo',
        'nombre_representante',
        'horas_servicio',

    ];


    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function classroom()
    {
        //REVISAR
        return $this->hasMany('App\Models\Classroom', 'campus_id', 'id');
    }


}
