<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;


class Banco extends Model implements Auditable
{
  protected $table = 'bancos';

  use HasFactory, \OwenIt\Auditing\Auditable;

  static $rules = [
    'nombre' => 'required',
  ];

  protected $perPage = 20;

  /**
   * Attributes that should be mass-assignable.
   *
   * @var array
   */
  protected $fillable = ['nombre'];


  /**
   * @return \Illuminate\Database\Eloquent\Relations\HasMany
   */
  public function pagos()
  {
    return $this->hasMany('App\Models\MetodoPago', 'banco_id', 'id');
  }
}
