<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;

class Audit extends Model implements Auditable
{
	use \OwenIt\Auditing\Auditable;

	protected $table = 'audits';

	static $rules = [];

	protected $perPage = 20;

	protected $fillable = [
		'user_type',
		'user_id',
		'event',
		'auditable_type',
		'auditable_id',
		'old_values',
		'new_values',
		'url',
		'ip_address',
		'user_agent',
		'tags',
	];

	/**
	 * Usuario que realizó la acción (morph).
	 */
	public function user()
	{
		// user_type = clase del modelo
		// user_id = id
		return $this->morphTo(null, 'user_type', 'user_id');
	}

	/**
	 * Modelo afectado por la acción (morph).
	 */
	public function auditable()
	{
		return $this->morphTo();
	}
}
