<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;


class Attendance extends Model implements Auditable
{
    protected $table = 'asistencias';

    use \OwenIt\Auditing\Auditable;
    
    static $rules = [
        'subjectclass_id' => 'required',
    ];

    protected $perPage = 20;

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['subjectclass_id', 'subjectenrollment_id', 'estado'];

    /**
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function subjectclass()
    {
        return $this->hasOne('App\Models\Subjectclass', 'id', 'subjectclass_id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function subjectenrollment()
    {
        return $this->hasOne('App\Models\Subjectenrollment', 'id', 'subjectenrollment_id');
    }
}




