<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;

class Agreement extends Model implements Auditable
{
    protected $table = 'convenios_efsrt';

    use \OwenIt\Auditing\Auditable;

    static $rules = [
		'company_id' => 'required',
    ];

    protected $perPage = 20;

    protected $fillable = ['company_id','fecha_inicio','fecha_fin','documento','descripcion'];

    public function practices()
    {
        return $this->hasMany('App\Models\Practice', 'agreement_id', 'id');
    }

    public function compamy()
    {
        return $this->hasOne('App\Models\Company', 'id', 'company_id');
    }

}
