<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;

/**
 * Class Admissionplan
 *
 * @property $id
 * @property $admission_id
 * @property $plan_id
 * @property $vacantes_ordinario
 * @property $vacantes_exoneracion
 * @property $created_at
 * @property $updated_at
 *
 * @property Admission $admission
 * @property Applicant[] $applicants
 * @property Plan $plan
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */
class Admissionplan extends Model implements Auditable
{
    protected $table = 'admisiones_planes';

    use HasFactory, \OwenIt\Auditing\Auditable;

    static $rules = [
		'admission_id' => 'required',
		'plan_id' => 'required',
		'vacantes_ordinario' => 'required',
		'vacantes_exoneracion' => 'required',
    ];

    protected $perPage = 20;

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['admission_id','plan_id','vacantes_ordinario','vacantes_exoneracion'];


    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function admission()
    {
        return $this->hasOne('App\Models\Admission', 'id', 'admission_id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function applicants()
    {
        return $this->hasMany('App\Models\Applicant', 'admissionplan_id', 'id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function plan()
    {
        return $this->hasOne('App\Models\Plan', 'id', 'plan_id');
    }


}
