<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;

class Administrator extends Model implements Auditable
{
    protected $table = 'administradores';

    use HasFactory, \OwenIt\Auditing\Auditable;

    static $rules = [
        'role_id' => 'required',
        'user_id' => 'required',
    ];

    protected $perPage = 20;

    protected $fillable = ['role_id', 'user_id'];


    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function role()
    {
        return $this->hasOne('App\Models\Role', 'id', 'role_id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function user()
    {
        return $this->hasOne('App\Models\User', 'id', 'user_id');
    }
}
