<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;
use Illuminate\Mail\Mailables\Attachment;

class EnviarCorreoTramiteDocumentario extends Mailable
{
    use Queueable, SerializesModels;

    public $asunto;
    public $solicitante;
    public $codigotd;
    public $rutaDocumento; 
    public $nombreAdjunto;

    /**
     * Create a new message instance.
     */
    public function __construct($asunto, $solicitante, $codigotd, $rutaDocumento, $nombreAdjunto)
    {

        $this->asunto = $asunto;
        $this->solicitante = $solicitante;
        $this->codigotd = $codigotd;
        $this->rutaDocumento = $rutaDocumento;
        $this->nombreAdjunto = $nombreAdjunto;
    }

    /**
     * Get the message envelope.
     */
    public function envelope(): Envelope
    {
        //configuracion mensaje del ASUNTO del correo
        return new Envelope(
            subject: "Registro de Solicitud de Trámite Documentario - {$this->codigotd}",
        );
    }

    /**
     * Get the message content definition.
     */
    public function content(): Content
    {
        //vista del contenido del correo
        return new Content(
            view: 'mail.solicitar.correotramitedoc',
        );
    }

    /**
     * Get the attachments for the message.
     *
     * @return array<int, \Illuminate\Mail\Mailables\Attachment>
     */
    public function attachments(): array
    {
        //nos permite adjuntar archivos
            return [
                Attachment::fromPath($this->rutaDocumento)
                    ->as($this->nombreAdjunto)
                    ->withMime('application/pdf'),
            ];
    }
}
