<?php

namespace App\Http\View\Composers;

use Illuminate\Support\Facades\DB;
use Illuminate\View\View;
use Illuminate\Support\Facades\Cache; // Añadimos la fachada de Cache

class InstitucionComposer
{
    /**
     * Bind data to the view.
     *
     * @param  \Illuminate\View\View  $view
     * @return void
     */
    public function compose(View $view)
    {
        $info = Cache::remember('institucion_info', 1, function () {
            return DB::table('info_institucional')->where('id', 1)->first();
        });


        $logoUrl = asset('images/institucion/logo.png');
        $bannerUrl = asset('images/institucion/banner.png');


        if ($info && $info->logo) {
            $logoUrl = route('admin.institucion.logo', ['file' => $info->logo]);
        }

    
        $view->with('logoUrl', $logoUrl)
            ->with('bannerUrl', $bannerUrl);
    }
}
