<?php

namespace App\Http\Middleware;

use App\Services\AuthService;
use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;

class CheckSession
{
    public function handle(Request $request, Closure $next): Response
    {
        // Excepciones para rutas específicas de Google y Microsoft Login
        $excludedPaths = [
            '/login-google',
            '/google-callback',
            '/login-microsoft',
            '/microsoft-callback'
        ];

        if (!Auth::check() && !in_array($request->path(), $excludedPaths) && $request->path() != 'login') {
            (new AuthService())->logout($request);
            return redirect()->route('login');
        }

        if (Auth::check() && ($request->is('login') || $request->is('/'))) {
            return back();
        }

        $response = $next($request);

        // Configuración de encabezados para evitar caché
        $response->headers->set('Cache-Control', 'no-store, no-cache, must-revalidate, max-age=0, post-check=0, pre-check=0');
        $response->headers->set('Pragma', 'no-cache');
        $response->headers->set('Expires', '0');

        return $response;
    }
}
