<?php

namespace App\Http\Middleware;

use App\Services\AuthService;
use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;

class CheckRole
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next, ...$roles): Response
    {
        $user = Auth::User();
        // verificar si hay usuario
        if (!$user) {
            (new AuthService())->logout($request);
            return redirect()->route('login');
        }

        $loggedUserType = $request->session()->get('loggedUserType');

        // obtener los roles del usuario
        $userRoles = [];
        if ($user->administradores->isNotEmpty()) $userRoles[] = 'admin';
        if ($user->teachers->isNotEmpty()) $userRoles[] = 'teacher';
        if ($user->students->isNotEmpty()) $userRoles[] = 'student';

        if (empty($userRoles)) {
            (new AuthService())->logout($request);
            return redirect()->route('login');
        }

        // return redirect()->route('login');
        // validar roles autorizados con roles del usuario
        foreach ($roles as $role) {
            if (in_array($role, $userRoles) && $loggedUserType === $role) {
                $response = $next($request);
                $response->headers->set('Cache-Control', 'no-store, no-cache, must-revalidate, max-age=0');
                $response->headers->set('Cache-Control', 'post-check=0, pre-check=0', false);
                $response->headers->set('Pragma', 'no-cache');
                $response->headers->set('Expires', '0');
                return  $response;
            }
        }

        // redireccionar según el rol del usuario
        if (in_array('admin', $userRoles) && $loggedUserType == 'admin') {
            $ruta = 'home.adm.dashboard';
        } else  if (in_array('teacher', $userRoles) && $loggedUserType == 'teacher') {
            $ruta = 'home.docente.index';
        } else  if (in_array('student', $userRoles) && $loggedUserType == 'student') {
            $ruta = 'home.student.index';
        } else {
            (new AuthService())->logout($request);
            $ruta = 'login';
        }
        return redirect()->route($ruta);
    }
}
