<?php

namespace App\Http\Controllers\tramite_documentario;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use \Illuminate\Support\Facades\Auth;


use App\Http\Controllers\sidebar\SidebarController;
use App\Models\RoleArea;
use App\Models\Td;
use App\Models\TdMovimiento;
use Carbon\Carbon;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Mail;
use App\Mail\RechazarEnviarCorreoTramiteDocumentario;
use App\Models\Area;

class TdMovimientoController extends Controller
{

    public function datatable(Request $request)
    {
        if ($request->ajax()) {

            $td_id = $request->input('td_id');

            $data = $this->get_by_td_id($td_id);

            return \Yajra\DataTables\DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los archivos'
        ]);
    }

    public function store_by_td_id($td_id, Request $request)
    {
        $area_origen_id = $request->input('area-origen');
        $areas_destino_id = $request->input('area-destino'); // array
        $nota = $request->input('nota');

        $areaMesaDePartes = Area::where('short_name', 'mesa_de_partes')->first();
        if (!$areaMesaDePartes) {
            return response()->json(["status" => false, "mensaje" => 'No existe el área Mesa de Partes']);
        }

        if (!is_array($areas_destino_id) || count($areas_destino_id) === 0) {
            return response()->json(["status" => false, "mensaje" => 'Debe seleccionar al menos un área destino']);
        }

        if (in_array($areaMesaDePartes->id, $areas_destino_id)) {
            return response()->json(["status" => false, "mensaje" => 'No puede derivar trámites hacia Mesa de Partes.']);
        }

        // validar que origen no esté dentro de los destinos
        if (in_array($area_origen_id, $areas_destino_id)) {
            return response()->json(["status" => false, "mensaje" => 'No se puede derivar a la misma área']);
        }

        $tdItem = Td::find($td_id);
        if (!$tdItem) {
            return response()->json(["status" => false, "mensaje" => 'No existe el trámite documentario']);
        }

        // validar que no se haya derivado anteriormente a la misma area
        foreach ($areas_destino_id as $destino) {
            $existeDerivacion = TdMovimiento::where('td_id', $td_id)
                ->where('area_destino_id', $destino)
                ->exists();

            if ($existeDerivacion) {

                $areaDestino = Area::find($destino);
                if (!$areaDestino) {
                    return response()->json(["status" => false, "mensaje" => 'Area seleccionada no existe']);
                }

                return response()->json([
                    "status" => false,
                    "mensaje" => "El trámite ya fue derivado anteriormente al área seleccionada"
                        . " (Área: $areaDestino->nombre)."
                ]);
            }
        }

        foreach ($areas_destino_id as $destino) {
            TdMovimiento::create([
                'td_id' => $td_id,
                'area_origen_id' => $area_origen_id,
                'area_destino_id' => $destino,
                'td_estado_id' => 1,
                'fecha' => now(),
                'nota' => $nota,
                'is_activo' => 1
            ]);
        }

        $tdItem->is_derivado = 1;

        // Guarda el nuevo registro en la base de datos
        if ($tdItem->save()) {
            return response()->json(["status" => true, "mensaje" => 'N.T. derivada correctamente']);
        }
        return response()->json(["status" => false, "mensaje" => 'N.T. no fue derivada correctamente']);
    }


    public function cancelar_by_td_id($td_id)
    {;

        $tdItem = Td::find($td_id);
        if (!$tdItem) {
            return response()->json(["status" => false, "mensaje" => 'No existe el trámite documentario']);
        }

        $tdItem->td_estado_id = 3;

        // Guarda el nuevo registro en la base de datos
        if ($tdItem->save()) {

            // CORREO
            $email_destino = $tdItem->correo;
            $area = $tdItem->area->nombre;
            $asunto = $tdItem->asunto;
            $solicitante = "{$tdItem->apellido_pa} {$tdItem->apellido_ma}, {$tdItem->nombres}";
            $codigo_nt = "{$tdItem->serie}-{$tdItem->numero}";
            $motivoRechazo = "Se rechaza por información incorrecta. Favor de reenviar otra NT";

            // Mail::to($email_destino)->send(new RechazarEnviarCorreoTramiteDocumentario($area, $asunto, $solicitante,  $codigo_nt, $motivoRechazo, $file, $nombredoc));
            Mail::to($email_destino)->send(new RechazarEnviarCorreoTramiteDocumentario($area, $asunto, $solicitante,  $codigo_nt, $motivoRechazo));
            // CORREO

            return response()->json(["status" => true, "mensaje" => 'N.T. cancelada correctamente']);
        }

        return response()->json(["status" => false, "mensaje" => 'N.T. no cancelada']);
    }

    // api

    public function get_by_td_id($td_id)
    {
        $data = TdMovimiento::where('td_id', $td_id)
            ->with(['area_origen', 'area_destino'])
            ->orderBy('fecha', 'desc')
            ->get();

        return $data;
    }
}
