<?php

namespace App\Http\Controllers\tramite_documentario;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use \Illuminate\Support\Facades\Auth;


use App\Http\Controllers\sidebar\SidebarController;
use App\Models\Td;
use Carbon\Carbon;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;

class TdMisTramitesController extends Controller
{
    // public function index()
    // {
    //     return view('tramite_documentario.index');
    // }

    public function index(Request $request)
    {
        return view('tramite_documentario.mis_tramites.index');
    }


    public function datatable(Request $request)
    {
        if ($request->ajax()) {

            $data = $this->get_mis_tramites();

            return \Yajra\DataTables\DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los archivos'
        ]);
    }


    // api

    public function get_mis_tramites()
    {
        $user = Auth::user();
        $data = Td::where('user_id', $user->id)
            ->with(['area','td_tipo','td_estado','user'])
            ->orderBy('fecha', 'desc')
            ->get();
        return $data;
    }
}
