<?php

namespace App\Http\Controllers\tramite_documentario;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use \Illuminate\Support\Facades\Auth;


use App\Http\Controllers\sidebar\SidebarController;
use App\Models\RoleArea;
use App\Models\Td;
use Carbon\Carbon;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;

class TdGestionarController extends Controller
{
    // public function index()
    // {
    //     return view('tramite_documentario.index');
    // }

    public function index(Request $request)
    {
        return view('tramite_documentario.gestionar.index');
    }


    public function datatable(Request $request)
    {
        if ($request->ajax()) {

            $data = $this->get_tramites();

            return \Yajra\DataTables\DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los archivos'
        ]);
    }


    // api

    public function get_tramites()
    {
        $user = Auth::user();

        $usertype_id = $user->usertype_id;

        // si no es administrador
        if (!in_array($usertype_id, [1, 4, 5, 7])) {
            return [];
        }

        // admin
        $admin = $user->administradores[0];

        // get role_id
        $role_id = $admin->role_id;

        // get areas by role_id
        $areas = RoleArea::where('role_id', $role_id)->pluck('area_id')->toArray();

        // td by areas
        // $data = Td::whereIn('area_id', $areas)
        //     ->with(['area', 'td_tipo', 'td_estado', 'user'])
        //     ->orderBy('fecha', 'desc')
        //     ->get();

        $data = Td::select(
            'tds.*',
            'areas.nombre as area_actual',

            'td_movimientos.id as td_movimiento_id',
            'td_movimientos.pdf_respuesta as td_movimiento_pdf_respuesta',
            'td_movimientos.nota_respuesta as td_movimiento_nota_respuesta',
            'td_movimientos.fecha_respuesta as td_movimiento_fecha_respuesta',

            'td_estados.id as td_movimiento_estado_id',
            'td_estados.nombre as td_movimiento_estado_nombre',
            'td_estados.color as td_movimiento_estado_color'
        )
            ->join('td_movimientos', function ($join) {
                $join->on('td_movimientos.td_id', '=', 'tds.id')
                    ->where('td_movimientos.is_activo', 1);
            })
            ->join('areas', 'areas.id', '=', 'td_movimientos.area_destino_id')
            ->leftJoin('td_estados', 'td_estados.id', '=', 'td_movimientos.td_estado_id')
            ->whereIn('td_movimientos.area_destino_id', $areas)
            ->with(['td_tipo', 'td_estado', 'user'])
            ->orderBy('tds.fecha', 'desc')
            ->get();

        return $data;
    }

    public function get_tramites_nuevos()
    {
        $user = Auth::user();

        $usertype_id = $user->usertype_id;

        // si no es administrador
        if (!in_array($usertype_id, [1, 4, 5, 7])) {
            return [];
        }

        // admin
        $admin = $user->administradores[0];

        // get role_id
        $role_id = $admin->role_id;

        // get areas by role_id
        $areas = RoleArea::where('role_id', $role_id)->pluck('area_id')->toArray();

        // td by areas
        $data = Td::whereIn('area_id', $areas)
            ->where('is_derivado', 0)
            ->with(['area', 'td_tipo', 'td_estado', 'user'])
            ->orderBy('fecha', 'desc')
            ->get();

        return $data;
    }


    public function index_libre(Request $request)
    {
        return view('tramite_documentario.gestionar_libre.index');
    }

    public function datatable_libre(Request $request)
    {
        if ($request->ajax()) {

            $data = $this->get_tramites();

            return \Yajra\DataTables\DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los archivos'
        ]);
    }

    public function datatable_nuevos_libre(Request $request)
    {
        if ($request->ajax()) {

            $data = $this->get_tramites_nuevos();

            return \Yajra\DataTables\DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los archivos'
        ]);
    }


    // api

    public function get_tramites_libre()
    {
        $user = Auth::user();

        $usertype_id = $user->usertype_id;

        // si no es administrador
        if (!in_array($usertype_id, [1, 4, 5, 7])) {
            return [];
        }

        // admin
        $admin = $user->administradores[0];

        // get role_id
        $role_id = $admin->role_id;

        // get areas by role_id
        $areas = RoleArea::where('role_id', $role_id)->pluck('area_id')->toArray();

        // td by areas
        $data = Td::whereIn('area_id', $areas)
            ->with(['area', 'td_tipo', 'td_estado', 'user'])
            ->orderBy('fecha', 'desc')
            ->get();

        return $data;
    }
}
