<?php

namespace App\Http\Controllers\tramite_documentario;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\Td;
use Illuminate\Support\Facades\Mail;
use App\Mail\RechazarEnviarCorreoTramiteDocumentario;
use App\Models\TdMovimiento;
use Carbon\Carbon;

class TdCancelarController extends Controller
{

    public function cancelar($td_id, Request $request)
    {

        $tdItem = Td::find($td_id);
        if (!$tdItem) {
            return response()->json(["status" => false, "mensaje" => 'Trámite Documentario no encontrado']);
        }

        // actualizar campos
        $tdItem->td_estado_id = 3;
        $tdItem->nota_respuesta = $request->input('nota_respuesta');

        // Guarda el nuevo registro en la base de datos
        if ($tdItem->save()) {

            // CORREO
            $email_destino = $tdItem->correo;
            $area = $tdItem->area->nombre;
            $asunto = $tdItem->info_asunto;
            $solicitante = "{$tdItem->apellido_pa} {$tdItem->apellido_ma}, {$tdItem->nombres}";
            $codigo_nt = "{$tdItem->serie}-{$tdItem->numero}";
            $motivoRechazo = $tdItem->nota_respuesta;

            // Mail::to($email_destino)->send(new RechazarEnviarCorreoTramiteDocumentario($area, $asunto, $solicitante,  $codigo_nt, $motivoRechazo, $file, $nombredoc));
            Mail::to($email_destino)->send(new RechazarEnviarCorreoTramiteDocumentario($area, $asunto, $solicitante,  $codigo_nt, $motivoRechazo));
            // CORREO

            return response()->json(["status" => true, "mensaje" => 'N.T. cancelada correctamente']);
        }

        return response()->json(["status" => false, "mensaje" => 'N.T. no cancelada']);
    }

    public function cancelar_movimiento($td_movimiento_id, Request $request)
    {

        $tdMovimientoItem = TdMovimiento::find($td_movimiento_id);
        if (!$tdMovimientoItem) {
            return response()->json(["status" => false, "mensaje" => 'Trámite Documentario Movimiento no encontrado']);
        }
        $tdItem = Td::find($tdMovimientoItem->td_id);
        if (!$tdItem) {
            return response()->json(["status" => false, "mensaje" => 'Trámite Documentario no encontrado']);
        }

        // actualizar campos
        $tdMovimientoItem->td_estado_id = 3;
        $tdMovimientoItem->nota_respuesta = $request->input('nota_respuesta');
        $tdMovimientoItem->fecha_respuesta = Carbon::now();

        // Guarda el nuevo registro en la base de datos
        if ($tdMovimientoItem->save()) {

            // CORREO
            $email_destino = $tdItem->correo;
            $area = $tdMovimientoItem->area_destino->nombre;
            $asunto = $tdItem->info_asunto;
            $solicitante = "{$tdItem->apellido_pa} {$tdItem->apellido_ma}, {$tdItem->nombres}";
            $codigo_nt = "{$tdItem->serie}-{$tdItem->numero}";
            $motivoRechazo = $tdItem->nota_respuesta;

            // Mail::to($email_destino)->send(new RechazarEnviarCorreoTramiteDocumentario($area, $asunto, $solicitante,  $codigo_nt, $motivoRechazo, $file, $nombredoc));
            Mail::to($email_destino)->send(new RechazarEnviarCorreoTramiteDocumentario($area, $asunto, $solicitante,  $codigo_nt, $motivoRechazo));
            // CORREO

            return response()->json(["status" => true, "mensaje" => 'N.T. cancelada correctamente']);
        }

        return response()->json(["status" => false, "mensaje" => 'N.T. no cancelada']);
    }
}
