<?php

namespace App\Http\Controllers\registros_pagos;

use App\Http\Controllers\Controller;

use App\Http\Controllers\sidebar\SidebarController;
use App\Models\Viatico;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ViaticoController extends Controller
{
    //
    public function index(Request $request)
    {
        return view('admin.registros_pagos.viaticos.index');
    }


    //
    public function list(Request $request)
    {

        if ($request->ajax()) {

            $data = DB::table('viaticos as vi')
            ->select(
                'vi.id as idviatico',
                'vi.descripcion',
                DB::raw('DATE_FORMAT(vi.fecha, "%d/%m/%Y") as fecha2'),
                'vi.fecha',
                'vi.documento',
                'vi.nro_operacion',
                'vi.monto',
                'vi.estado',
                'usu.id as idusuario',
                'ti_usu.tipo as tipoidenti_usu',
                'usu.nroidenti as nroidenti_usu',
                'usu.nombres as nombres_usu',
                'usu.apellido_pa as apellido_pa_usu',
                'usu.apellido_ma as apellido_ma_usu',
                'usu.telefono as telefono_usu',
                'usu.celular as celular_usu',
                'usu.correo as correo_usu',
                'ad.id as idadmin',
                'usad.id as idusuario_adm',
                'ti_usad.tipo as tipoidenti_adm',
                'usad.nroidenti as nroidenti_adm',
                'usad.nombres as nombres_adm',
                'usad.apellido_pa as apellido_pa_adm',
                'usad.apellido_ma as apellido_ma_adm',
                'usad.telefono as telefono_adm',
                'usad.celular as celular_adm',
                'usad.correo as correo_adm',
                'mepa.id as idmetodopago',
                'mepa.nombre as nombremetodopago',
                'ba.id as idbanco',
                'ba.nombre as nombrebanco'
            )
            ->join('usuarios as usu', 'vi.usuario_id', '=', 'usu.id')
            ->join('tipos_identificaciones as ti_usu', 'usu.identificationtype_id', '=', 'ti_usu.id')
            ->join('administradores as ad', 'vi.administrator_id', '=', 'ad.id')
            ->join('usuarios as usad', 'ad.user_id', '=', 'usad.id')
            ->join('tipos_identificaciones as ti_usad', 'usad.identificationtype_id', '=', 'ti_usad.id')
            ->leftJoin('metodos_pagos as mepa', 'vi.metodo_pago_id', '=', 'mepa.id')
            ->leftJoin('bancos as ba', 'vi.banco_id', '=', 'ba.id')
            ->orderBy('vi.fecha','desc')
            ->get();

            return \Yajra\DataTables\DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los archivos'
        ]);
    }

    public function store(Request $request)
    {
        // Validador
        $validator = Validator::make($request->all(), [
            'txt-documento' => '|mimes:pdf,jpg,jpeg,png|max:5000', // Valida PDF y tamaño máximo de 2MB
        ], [
            'txt-documento.mimes' => 'El archivo debe ser un archivo PDF o Imagen',
            'txt-documento.max' => 'El tamaño del archivo no debe superar los 5000 KB.',
        ]);

        if ($validator->fails()) {
            return response()->json([
                "status" => false, "errors" => $validator->errors(),
            ]);
        } else {
            // nuevo objeto
            $item = new Viatico();
            $item->usuario_id = $request->input('txt-usuario_id');
            $item->administrator_id = Auth::User()->id;
            $item->descripcion = $request->input('txt-descripcion');
            $item->monto = $request->input('txt-monto');
            $item->fecha = $request->input('txt-fecha');
            $item->estado = $request->input('txt-estado');
            $item->metodo_pago_id = $request->input('txt-metodo_pago');
            $item->banco_id = $request->input('txt-banco');
            $item->nro_operacion = $request->input('txt-nro_operacion');

            $item->save();
            $idviatico = $item->id;

            // guardar documento si existe
            if ($request->hasFile('txt-documento')) {
                $folderName =  'public/viaticos/usuario-' . $request->input('txt-usuario_id');
                Storage::disk('local')->makeDirectory($folderName);   // creamos la carpeta en el disco local
                $archivo = $request->file('txt-documento');   // obtenemos el archivo
                $extension = $archivo->getClientOriginalExtension();
                $archivo->storeAs($folderName, $idviatico . '.' . $extension);  // guardado (ruta,nombre del archivo)
                $filePath = $folderName . '/' . $idviatico . '.' . $extension;  // ruta del archivo
                $item->documento = $filePath;
                // guardar Pago - documento
                if ($item->save()) {
                    return response()->json(["status" => true, "mensaje" => 'Pago actualizado']);
                }
            }

            // validar guardado
            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Registro insertado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no insertado']);
            }
        }
    }

    public function update(Request $request)
    {
        // Validador
        $validator = Validator::make($request->all(), [
            'txt-documento' => '|mimes:pdf,jpg,jpeg,png|max:5000', // Valida PDF y tamaño máximo de 2MB
        ], [
            'txt-documento.mimes' => 'El archivo debe ser un archivo PDF o Imagen',
            'txt-documento.max' => 'El tamaño del archivo no debe superar los 5000 KB.',
        ]);

        if ($validator->fails()) {
            return response()->json([
                "status" => false, "errors" => $validator->errors(),
            ]);
        } else {
            // nuevo objeto
            $item = Viatico::find($request->input('txt-idviatico'));
            $item->usuario_id = $request->input('txt-usuario_id');
            $item->descripcion = $request->input('txt-descripcion');
            $item->monto = $request->input('txt-monto');
            $item->fecha = $request->input('txt-fecha');
            $item->estado = $request->input('txt-estado');
            $item->metodo_pago_id = $request->input('txt-metodo_pago_id');
            $item->banco_id = $request->input('txt-banco_id');
            $item->nro_operacion = $request->input('txt-nro_operacion');

            $idviatico = $request->input('txt-idviatico');

            // guardar documento si existe
            if ($request->hasFile('txt-documento')) {
                $folderName =  'public/viaticos/usuario-' . $request->input('txt-usuario_id');
                Storage::disk('local')->makeDirectory($folderName);   // creamos la carpeta en el disco local
                $archivo = $request->file('txt-documento');   // obtenemos el archivo
                $extension = $archivo->getClientOriginalExtension();
                $archivo->storeAs($folderName, $idviatico . '.' . $extension);  // guardado (ruta,nombre del archivo)
                $filePath = $folderName . '/' . $idviatico . '.' . $extension;  // ruta del archivo
                $item->documento = $filePath;
                // guardar Pago - documento
                if ($item->save()) {
                    return response()->json(["status" => true, "mensaje" => 'Pago actualizado']);
                }
            }

            // validar guardado
            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Registro insertado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no insertado']);
            }
        }
    }


    public function destroy($id)
    {
        // Busca el registro por su ID
        $item = Viatico::find($id);

        // Verifica si el registro existe
        if (!$item) {
            return response()->json(["status" => false, "mensaje" => 'El registro no existe']);
        }

        $ruta = $item->documento;
        $file = storage_path('app/' . $ruta);
        if (File::exists($file)) {
            File::delete($file);
        }

        // Elimina el registro de la base de datos
        if ($item->delete()) {
            return response()->json(["status" => true, "mensaje" => 'El registro fue eliminado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'El registro no fue eliminado']);
        }
    }


    public function ajax_all(Request $request)
    {
        if ($request->ajax()) {

            $data = Viatico::all();

            return response()->json($data);
        }
        return  response()->json(["status" => false, "mensaje" => 'Error en request']);
    }
}
