<?php

namespace App\Http\Controllers\registros_pagos;

use App\Http\Controllers\Controller;

use App\Http\Controllers\sidebar\SidebarController;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class TesoreriaReporteController extends Controller
{
    //
    public function index(Request $request)
    {
        return view('admin.registros_pagos.reportes.index');
    }

    public function grafica_1(Request $request, $anho, $mesinicio, $mesfin)
    {
        if ($request->ajax()) {

            DB::statement("SET lc_time_names = 'es_ES'");
            // query
            $data = DB::table('pagos AS pa')
                ->join('estudiantes AS e', 'e.id', '=', 'pa.student_id')
                ->join('planes AS pl', 'pl.id', '=', 'e.plan_id')
                ->join('programas AS pr', 'pr.id', '=', 'pl.program_id')
                ->select(
                    'pr.id AS idprograma',
                    'pr.nombre AS programa',
                    DB::raw('SUM(pa.monto_final) AS total')
                )
                ->whereYear('pa.fecha', $anho)
                ->whereBetween(DB::raw('MONTH(pa.fecha)'), [$mesinicio, $mesfin])
                ->groupBy('idprograma', 'programa')
                ->orderBy('programa')
                ->get();

            // data
            return response()->json($data);
        }

        return  response()->json(["status" => false, "mensaje" => 'Error: no se pueden cargar los archivos']);
    }


    public function grafica_2(Request $request, $anho, $mesinicio, $mesfin, $studentId)
    {
        if ($request->ajax()) {

            DB::statement("SET lc_time_names = 'es_ES'");
            // query
            $data = DB::table('pagos as p')
                ->join('conceptos as c', 'c.id', '=', 'p.concepto_id')
                ->join('estudiantes as e', 'e.id', '=', 'p.student_id')
                ->select('c.nombre as concepto', DB::raw('SUM(p.monto_final) as total'))
                ->whereYear('fecha', $anho)
                ->whereBetween(DB::raw('MONTH(fecha)'), [$mesinicio, $mesfin])
                ->where('e.id', $studentId)
                ->groupBy('concepto')
                ->orderBy('concepto')
                ->get();

            // data
            return response()->json($data);
        }

        return  response()->json(["status" => false, "mensaje" => 'Error: no se pueden cargar los archivos']);
    }

    public function grafica_3(Request $request, $anho, $mesinicio, $mesfin)
    {
        if ($request->ajax()) {

            DB::statement("SET lc_time_names = 'es_ES'");
            // query
            $data = DB::table('pagos as p')
                ->join('metodos_pagos as mp', 'mp.id', '=', 'p.metodo_pago_id')
                ->where('p.estado', 1)
                ->select('mp.nombre as metodo_pago', DB::raw('SUM(p.monto_final) as total'))
                ->whereYear('fecha', $anho)
                ->whereBetween(DB::raw('MONTH(fecha)'), [$mesinicio, $mesfin])
                ->groupBy('metodo_pago')
                ->orderBy('metodo_pago')
                ->get();

            return response()->json($data);
        }

        return  response()->json(["status" => false, "mensaje" => 'Error: no se pueden cargar los archivos']);
    }

    public function grafica_4(Request $request, $anho, $mesinicio, $mesfin)
    {
        if ($request->ajax()) {

            DB::statement("SET lc_time_names = 'es_ES'");

            $data = DB::table('pagos as p')
                ->join('estudiantes as e', 'e.id', '=', 'p.student_id')
                ->where('p.estado', '<>', 1)          // pagos morosos
                ->where('e.estado', 1)               // estudiantes activos
                ->whereYear('p.fecha', $anho)
                ->whereBetween(DB::raw('MONTH(p.fecha)'), [$mesinicio, $mesfin])
                ->select(
                    DB::raw('MONTH(p.fecha) AS mes_num'),
                    DB::raw("DATE_FORMAT(p.fecha, '%M') AS mes_nombre"),
                    DB::raw('COUNT(DISTINCT p.student_id) AS cantidad_morosos')
                )
                ->groupBy('mes_num', 'mes_nombre')
                ->orderBy('mes_num')
                ->get();

            return response()->json($data);
        }

        return response()->json([
            "status"  => false,
            "mensaje" => 'Error: no se pueden cargar los datos',
        ]);
    }

    public function listado(Request $request, $anho, $mesinicio, $mesfin){
        if ($request->ajax()){

            DB::statement("SET lc_time_names = 'es_ES'");

            $data = DB::table('pagos as p')
                ->join('estudiantes as e', 'e.id', '=', 'p.student_id')
                ->join('usuarios as u', 'u.id', '=', 'e.user_id')
                ->where('p.estado', '<>', 1)
                ->where('e.estado', 1)
                ->whereYear('p.fecha', $anho)
                ->whereBetween(DB::raw('MONTH(p.fecha)'), [$mesinicio, $mesfin])
                ->select(DB::raw("CONCAT(u.nombres, ' ', u.apellido_pa, ' ', u.apellido_ma) as alumno"))
                ->groupBy('alumno')
                ->orderBy('alumno')
                ->get();

            return response()->json($data);
        }

        return  response()->json(["status" => false, "mensaje" => 'Error: no se pueden cargar los archivos']);
    }

    public function grafica_5(Request $request, $anho, $mesinicio, $mesfin){
        if ($request->ajax()){

            DB::statement("SET lc_time_names = 'es_ES'");

            $data = DB::table('pagos as p')
                ->join('conceptos as c', 'c.id', '=', 'p.concepto_id')
                ->where('p.estado', 1)
                ->whereYear('p.fecha', $anho)
                ->whereBetween(DB::raw('MONTH(p.fecha)'), [$mesinicio, $mesfin])
                ->select('c.nombre as concepto', DB::raw('SUM(p.monto_final) as total'))
                ->groupBy('c.nombre')
                ->orderBy('c.nombre')
                ->get();

                return response()->json($data);
        }

        return  response()->json(["status" => false, "mensaje" => 'Error: no se pueden cargar los archivos']);
    }

    public function ingresos_egresos(Request $request, $anho, $mesinicio, $mesfin)
    {
        if ($request->ajax()) {

            DB::statement("SET lc_time_names = 'es_ES'");
            // query
            $data = DB::table(DB::raw("(
                    SELECT SUM(monto_final) AS ingresos, 0 AS egresos
                    FROM pagos
                    WHERE YEAR(fecha) = ? AND MONTH(fecha) BETWEEN ? AND ?

                    UNION ALL

                    SELECT 0 AS ingresos, SUM(monto) AS egresos
                    FROM viaticos
                    WHERE YEAR(fecha) = ? AND MONTH(fecha) BETWEEN ? AND ?
                ) AS totales"))
                ->selectRaw('
                    CONCAT("S/. ", SUM(ingresos)) AS ingresos,
                    CONCAT("S/. ", SUM(egresos)) AS egresos,
                    CONCAT("S/. ", (SUM(ingresos) - SUM(egresos))) AS total')
                ->setBindings([$anho, $mesinicio, $mesfin, $anho, $mesinicio, $mesfin])
                ->get();

            // data
            return response()->json($data);
        }

        return  response()->json(["status" => false, "mensaje" => 'Error: no se pueden cargar los archivos']);
    }
}
