<?php

namespace App\Http\Controllers\registros_pagos;

use App\Http\Controllers\Controller;

use App\Http\Controllers\sidebar\SidebarController;
use App\Models\Pago;
use App\Models\PagoMatricula;
use App\Models\Semesterenrollment;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class PagoController extends Controller
{
    //
    public function index(Request $request)
    {
        return view('admin.registros_pagos.pagos.index');
    }


    //
    public function list(Request $request)
    {
        if ($request->ajax()) {

            $idconcepto = $request->input('idconcepto');
            $idstudent = $request->input('idstudent');
            $estado_pago = $request->input('estado_pago');

            $data = DB::table('pagos as pa')
                ->select(
                    'pr.id as idprogram',
                    'pa.id as idpago',
                    DB::raw('DATE_FORMAT(pa.fecha, "%d/%m/%Y") as fecha2'),
                    'pa.fecha',
                    'pa.documento',
                    'pa.nro_operacion',
                    'pa.monto_inicial',
                    'pa.descuento',
                    'pa.monto_final',
                    'pa.estado',
                    'pa.resolucion',
                    'pa.descripcion',
                    'se.id as idsemester',
                    DB::raw('COALESCE(CONCAT(se.anho, "-", se.numero), "") as semestre'),
                    'es.id as idstudent',
                    'uses.id as idusuario_est',
                    'tiid_est.tipo as tipoidenti_est',
                    'uses.nroidenti as nroidenti_est',
                    'uses.nombres as nombres_est',
                    'uses.apellido_pa as apellido_pa_est',
                    'uses.apellido_ma as apellido_ma_est',
                    DB::raw('CONCAT(uses.nombres, " ",uses.apellido_pa , " ",uses.apellido_ma) as estudiante'),
                    'uses.telefono as telefono_est',
                    'uses.celular as celular_est',
                    'uses.correo as correo_est',
                    'ad.id as idadmin',
                    'usad.id as idusuario_adm',
                    'tiid_adm.tipo as tipoidenti_adm',
                    DB::raw('COALESCE(usad.nroidenti, "") as nroidenti_adm'),
                    DB::raw('COALESCE(usad.nombres, "") as nombres_adm'),
                    DB::raw('COALESCE(usad.apellido_pa, "") as apellido_pa_adm'),
                    DB::raw('COALESCE(usad.apellido_ma, "") as apellido_ma_adm'),
                    DB::raw('COALESCE(usad.telefono, "") as telefono_adm'),
                    DB::raw('COALESCE(usad.celular, "") as celular_adm'),
                    DB::raw('COALESCE(usad.correo, "") as correo_adm'),
                    'co.id as idconcepto',
                    'co.nombre as nombreconcepto',
                    DB::raw('CASE WHEN co.id = 1 THEN CONCAT(co.nombre, " ", se.anho, "-", se.numero) ELSE co.nombre END as concepto_semestre'),
                    'mepa.id as idmetodopago',
                    'mepa.nombre as nombremetodopago',
                    'ba.id as idbanco',
                    'ba.nombre as nombrebanco',
                    'se.id as idsemester',
                    'pa.exoneration_id' // <--- AÑADIR ESTE CAMPO
                )
                ->join('estudiantes as es', 'pa.student_id', '=', 'es.id')
                ->join('planes as pl', 'pl.id', '=', 'es.plan_id')
                ->join('programas as pr', 'pr.id', '=', 'pl.program_id')
                ->join('usuarios as uses', 'es.user_id', '=', 'uses.id')
                ->join('tipos_identificaciones as tiid_est', 'uses.identificationtype_id', '=', 'tiid_est.id')
                ->leftJoin('administradores as ad', 'pa.administrator_id', '=', 'ad.id')
                ->leftJoin('usuarios as usad', 'ad.user_id', '=', 'usad.id')
                ->leftJoin('tipos_identificaciones as tiid_adm', 'usad.identificationtype_id', '=', 'tiid_adm.id')
                ->leftJoin('conceptos as co', 'pa.concepto_id', '=', 'co.id')
                ->leftJoin('metodos_pagos as mepa', 'pa.metodo_pago_id', '=', 'mepa.id')
                ->leftJoin('bancos as ba', 'pa.banco_id', '=', 'ba.id')
                ->leftJoin('semestres as se', 'pa.semester_id', '=', 'se.id')
                ->orderBy('pa.fecha', 'desc');

            if ($idconcepto != "all") {
                $data = $data->where('co.id', $idconcepto);
            }

            if ($idstudent != "all") {
                $data = $data->where('es.id', $idstudent);
            }

            if ($estado_pago != "all") {
                $data = $data->where('pa.estado', $estado_pago);
            }

            $data = $data->get();

            return \Yajra\DataTables\DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los archivos'
        ]);
    }


    public function store(Request $request)
    {
        // validar documento
        $validator = Validator::make($request->all(), [
            'txt-documento' => 'mimes:pdf,jpg,png|max:2000', // Valida PDF y tamaño máximo de 2MB
        ], [
            'txt-documento.mimes' => 'El archivo debe ser un PDF.',
            'txt-documento.max' => 'El tamaño del archivo no debe superar los 2000 KB.',
        ]);
        // documento inválido
        if ($validator->fails()) {
            return response()->json([
                "status" => 'validators',
                "mensaje" => $validator->errors(),
            ]);
        } else {
            // nuevo Pago
            $item = new Pago();
            $item->student_id = $request->input('txt-student_id');
            $item->administrator_id = Auth::user()->administradores[0]->id;
            $item->concepto_id = $request->input('txt-concepto_id');
            $item->metodo_pago_id = $request->input('txt-metodo_pago_id');
            $item->banco_id = $request->input('txt-banco_id');
            $item->fecha = $request->input('txt-fecha');
            $item->monto_inicial = $request->input('txt-monto_inicial');
            $item->descuento = $request->input('txt-descuento');
            $item->monto_final = $request->input('txt-monto_final');
            $item->estado = $request->input('txt-estado');
            $item->nro_operacion = $request->input('txt-nro_operacion');
            $item->descripcion = $request->input('txt-descripcion');
            $item->exoneration_id = $request->input('txt-exoneration_id');
            $item->documento = '--';
            $item->resolucion = '--';
            $item->documento_descuento = '--'; // <-- Inicializar el nuevo campo

            $item->save();
            $idpago = $item->id;

            // guardar documento si existe
            if ($request->hasFile('txt-documento')) {
                $folderName =  'public/students/' . $request->input('txt-student_id') . '/' . 'pagos/' . $idpago;
                Storage::disk('local')->makeDirectory($folderName);   // creamos la carpeta en el disco local
                $archivo = $request->file('txt-documento');   // obtenemos el archivo
                $archivo->storeAs($folderName, 'voucher.pdf');  // guardado (ruta,nombre del archivo)
                $filePath = $folderName . '/' . 'voucher.pdf';  // ruta del archivo
                $item->documento = $filePath;
                // guardar Pago - documento
                if ($item->save()) {
                    return response()->json(["status" => true, "mensaje" => 'Pago actualizado']);
                }
            }

            // guardar resolucion si existe
            if ($request->hasFile('txt-resolucion')) {
                $folderName =  'public/students/' . $request->input('txt-student_id') . '/' . 'pagos/' . $idpago;
                Storage::disk('local')->makeDirectory($folderName);   // creamos la carpeta en el disco local
                $archivo = $request->file('txt-resolucion');   // obtenemos el archivo
                $archivo->storeAs($folderName, 'resolucion.pdf');  // guardado (ruta,nombre del archivo)
                $filePath = $folderName . '/' . 'resolucion.pdf';  // ruta del archivo
                $item->resolucion = $filePath;
                // guardar Pago - resolucion
                if ($item->save()) {
                    return response()->json(["status" => true, "mensaje" => 'Pago actualizado']);
                }
            }

            // guardar documento descuento si existe
            if ($request->hasFile('txt-documento_descuento')) {
                $folderName = 'public/students/' . $request->input('txt-student_id') . '/pagos/' . $idpago;
                Storage::disk('local')->makeDirectory($folderName);
                $archivo = $request->file('txt-documento_descuento');
                // Guardamos el archivo con un nombre estandarizado
                $nombreArchivo = 'documento_descuento.' . $archivo->getClientOriginalExtension();
                $archivo->storeAs($folderName, $nombreArchivo);
                $filePath = $folderName . '/' . $nombreArchivo;
                $item->documento_descuento = $filePath;
                $item->save(); // Guardar la ruta en la base de datos
            }

            // guardar
            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Pago registrado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Pago no registrado']);
            }
        }
    }


    public function update(Request $request)
    {
        // validar documento
        $validator = Validator::make($request->all(), [
            'txt-documento' => 'mimes:pdf,jpg,png|max:2000', // Valida PDF y tamaño máximo de 2MB
        ], [
            'txt-documento.mimes' => 'El archivo debe ser un PDF.',
            'txt-documento.max' => 'El tamaño del archivo no debe superar los 2000 KB.',
        ]);
        // documento inválido
        if ($validator->fails()) {
            return response()->json([
                "status" => 'validators',
                "mensaje" => $validator->errors(),
            ]);
        } else {
            // nuevo Pago
            $item = Pago::find($request->input('txt-idpago'));
            $item->administrator_id = Auth::user()->administradores[0]->id;
            $item->concepto_id = $request->input('txt-concepto_id');
            $item->metodo_pago_id = $request->input('txt-metodo_pago_id');
            $item->banco_id = $request->input('txt-banco_id');
            $item->fecha = $request->input('txt-fecha');
            $item->monto_inicial = $request->input('txt-monto_inicial');
            $item->descuento = $request->input('txt-descuento');
            $item->monto_final = $request->input('txt-monto_final');
            $item->estado = $request->input('txt-estado');
            $item->nro_operacion = $request->input('txt-nro_operacion');
            $item->exoneration_id = $request->input('txt-exoneration_id');
            $item->documento = '--';


            $idpago = $request->input('txt-idpago');

            // guardar documento si existe
            if ($request->hasFile('txt-documento')) {
                $folderName =  'public/students/' . $request->input('txt-student_id') . '/' . 'pagos/' . $idpago;
                Storage::disk('local')->makeDirectory($folderName);   // creamos la carpeta en el disco local
                $archivo = $request->file('txt-documento');   // obtenemos el archivo
                $archivo->storeAs($folderName, 'voucher.pdf');  // guardado (ruta,nombre del archivo)
                $filePath = $folderName . '/' . 'voucher.pdf';  // ruta del archivo
                $item->documento = $filePath;
                // guardar Pago - documento
                if ($item->save()) {
                    return response()->json(["status" => true, "mensaje" => 'Pago actualizado']);
                }
            }

            // guardar resolucion si existe
            if ($request->hasFile('txt-resolucion')) {
                $folderName =  'public/students/' . $request->input('txt-student_id') . '/' . 'pagos/' . $idpago;
                Storage::disk('local')->makeDirectory($folderName);   // creamos la carpeta en el disco local
                $archivo = $request->file('txt-resolucion');   // obtenemos el archivo
                $archivo->storeAs($folderName, 'resolucion.pdf');  // guardado (ruta,nombre del archivo)
                $filePath = $folderName . '/' . 'resolucion.pdf';  // ruta del archivo
                $item->resolucion = $filePath;
                // guardar Pago - resolucion
                if ($item->save()) {
                    return response()->json(["status" => true, "mensaje" => 'Pago actualizado']);
                }
            }

            // guardar documento descuento si existe
            if ($request->hasFile('txt-documento_descuento')) {
                $folderName = 'public/students/' . $item->student_id . '/pagos/' . $idpago; // Usar el student_id del item existente
                Storage::disk('local')->makeDirectory($folderName);
                $archivo = $request->file('txt-documento_descuento');
                $nombreArchivo = 'documento_descuento.' . $archivo->getClientOriginalExtension();
                $archivo->storeAs($folderName, $nombreArchivo);
                $filePath = $folderName . '/' . $nombreArchivo;
                $item->documento_descuento = $filePath;
            }

            // guardar
            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Pago actualizado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Pago no actualizado']);
            }
        }
    }


    public function destroy($id)
    {
        // Busca el registro por su ID
        $item = Pago::find($id);

        // Verifica si el registro existe
        if (!$item) {
            return response()->json(["status" => false, "mensaje" => 'El registro no existe']);
        }

        $ruta = $item->documento;
        $file = storage_path('app/' . $ruta);
        if (File::exists($file)) {
            File::delete($file);
        }

        // Elimina el registro de la base de datos
        if ($item->delete()) {
            return response()->json(["status" => true, "mensaje" => 'El registro fue eliminado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'El registro no fue eliminado']);
        }
    }


    public function ajax_all(Request $request)
    {
        if ($request->ajax()) {

            $data = Pago::all();

            return response()->json($data);
        }
        return  response()->json(["status" => false, "mensaje" => 'Error en request']);
    }
}
