<?php

namespace App\Http\Controllers\registros_pagos;

use App\Http\Controllers\Controller;

use App\Http\Controllers\sidebar\SidebarController;
use App\Models\Concepto;
use \Illuminate\Support\Facades\Auth;

use Illuminate\Http\Request;

class ConceptoController extends Controller
{
    //
    public function index(Request $request)
    {
        return view('admin.registros_pagos.conceptos.index');
    }


    //
    public function list(Request $request)
    {
        if ($request->ajax()) {

            $data = Concepto::get();

            return \Yajra\DataTables\DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los archivos'
        ]);
    }


    public function store(Request $request)
    {

        $item = new Concepto();
        $item->nombre = $request->input('txt-nombre');
        $item->monto = $request->input('txt-monto');
        // Asigna otros campos según tus necesidades

        // Guarda el nuevo registro en la base de datos
        if ($item->save()) {
            return response()->json(["status" => true, "mensaje" => 'Registro insertado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'Registro no insertado']);
        }
    }


    public function update(Request $request, $id)
    {
        $item = Concepto::find($id);

        if (!$item) {
            abort(404); // Manejo de error si no se encuentra el registro
        } else {
            $item->nombre = $request->input('txt-nombre');
            $item->monto = $request->input('txt-monto');

            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
            }
        }
    }


    public function destroy($id)
    {

        if ($id == 1) {
            return response()->json(["status" => false, "mensaje" => 'La matrícula no se puede eliminar']);
        }

        // Busca el registro por su ID
        $item = Concepto::find($id);

        // Verifica si el registro existe
        if (!$item) {
            return response()->json(["status" => false, "mensaje" => 'El registro no existe']);
        }

        // Elimina el registro de la base de datos
        if ($item->delete()) {
            return response()->json(["status" => true, "mensaje" => 'El registro fue eliminado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'El registro no fue eliminado']);
        }
    }


    public function ajax_all(Request $request)
    {
        if ($request->ajax()) {


            $data = Concepto::orderBy("nombre")->get();
            return response()->json($data);
        }
        return  response()->json(["status" => false, "mensaje" => 'Error en request']);
    }
}
