<?php

namespace App\Http\Controllers\home;

use App\Http\Controllers\Controller;
use App\Models\Student;
use Illuminate\Support\Facades\DB;

class DashboardController extends Controller
{

    public function getStats()
    {
        $datos = DB::table(DB::raw("(
                        SELECT 'estudiantes' AS tipo, COUNT(1) AS cantidad FROM estudiantes
                        UNION ALL
                        SELECT 'docentes' AS tipo, COUNT(1) AS cantidad FROM docentes
                        UNION ALL
                        SELECT 'programas' AS tipo, COUNT(1) AS cantidad FROM programas
                        UNION ALL
                        SELECT 'administradores' AS tipo, COUNT(1) AS cantidad FROM administradores
                    ) as resumen"))->get();
        return $datos;
    }

    public function getRecaudacionPorMes()
    {
        DB::statement("SET lc_time_names = 'es_ES'");

        $datos = DB::table('pagos')
            ->selectRaw("
                MONTH(fecha) AS mes_num,
                CONCAT(UCASE(LEFT(MONTHNAME(fecha), 1)), LCASE(SUBSTRING(MONTHNAME(fecha), 2))) AS mes_nombre,
                SUM(CASE WHEN estado = 1 THEN monto_final ELSE 0 END) AS recaudado,
                SUM(CASE WHEN estado != 1 THEN monto_final ELSE 0 END) AS por_cobrar
            ")
            ->whereRaw('YEAR(fecha) = YEAR(CURDATE())')
            ->groupBy('mes_num', 'mes_nombre')
            ->orderBy('mes_num')
            ->get();

        return $datos;
    }


    public function getRecaudacionPorConcepto()
    {
        $datos = DB::table('pagos as p')
            ->join('conceptos as c', 'c.id', '=', 'p.concepto_id')
            ->select(
                'c.nombre as concepto',
                DB::raw('SUM(CASE WHEN p.estado = 1 THEN p.monto_final ELSE 0 END) AS recaudado'),
                DB::raw('SUM(CASE WHEN p.estado != 1 THEN p.monto_final ELSE 0 END) AS por_cobrar')
            )
            ->whereYear('p.fecha', DB::raw('YEAR(CURDATE())'))
            ->groupBy('c.nombre')
            ->orderBy('c.nombre')
            ->get();

        return $datos;
    }

    public function getEstudiantesPrograma()
    {
        $datos = Student::join('planes as pl', 'estudiantes.plan_id', '=', 'pl.id')
            ->join('programas as pr', 'pl.program_id', '=', 'pr.id')
            ->join('usuarios as u', 'estudiantes.user_id', '=', 'u.id')
            ->join('generos as gr', 'u.genre_id', '=', 'gr.id')
            ->select(
                'pr.nombre as programa',
                DB::raw('COUNT(CASE WHEN gr.nombre = "Masculino" THEN estudiantes.id END) AS masculino'),
                DB::raw('COUNT(CASE WHEN gr.nombre = "Femenino" THEN estudiantes.id END) AS femenino'),
                DB::raw('COUNT(CASE WHEN gr.nombre = "Otro" THEN estudiantes.id END) AS otros')
            )
            ->groupBy('pr.nombre')
            ->get();

        return $datos;
    }

    public function getEgresadosAnho()
    {
        $datos = Student::select(
            DB::raw('YEAR(estudiantes.fec_egreso) as anho_egreso'),
            DB::raw('COUNT(estudiantes.id) as total_egresados')
        )
            ->whereNotNull('estudiantes.fec_egreso')
            ->whereIn('estudiantes.estado', [5, 6])
            ->groupBy(DB::raw('YEAR(estudiantes.fec_egreso)'))
            ->orderBy(DB::raw('anho_egreso'))
            ->get();

        return $datos;


        return $datos;
    }
}
