<?php

namespace App\Http\Controllers\docente;

use App\Http\Controllers\Controller;
use App\Models\TeacherDocument;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;

class RequisitosController extends Controller
{
    public function index()
    {
        return view('docente.requisitos.index');
    }


    public function list(Request $request)
    {
        if ($request->ajax()) {
            $teacherId = auth()->user()->id;

            $data = DB::table('requisitos_docentes as r')
                ->leftJoin('documentos_docentes as d', function ($join) use ($teacherId) {
                    $join->on('d.teacher_requirement_id', '=', 'r.id')
                        ->where('d.teacher_id', '=', $teacherId);
                })
                ->select(
                    'r.id as requirement_id',
                    'r.nombre as requirement_name',
                    'd.id',
                    'd.teacher_id',
                    'd.documento',
                    'd.estado'
                )
                ->get();

            return \Yajra\DataTables\DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }

        return  response()->json(["status" => false, "mensaje" => 'Error: no se pueden cargar los archivos']);
    }


    public function update(Request $request, $id)
    {
        $item = TeacherDocument::find($id);

        $validator = Validator::make($request->all(), [
            'txt-requirement_id' => 'required|integer|exists:requisitos_docentes,id',
            'txt-documento' => 'nullable|file|mimes:pdf|max:102400'
        ]);

        if ($validator->fails()) {
            return response()->json(["status" => false, "mensaje" => $validator->errors()->first()]);
        }

        try {
            // Si no existe, crear uno nuevo
            if (!$item) {
                $item = new TeacherDocument();
            }

            $item->teacher_requirement_id = $request->input('txt-requirement_id');
            $item->teacher_id = auth()->user()->id;
            $item->approved_by = null;
            $item->estado = 0;

            $item->save();

            // Guardar si hay archivo
            if ($request->hasFile('txt-documento')) {
                $file = $request->file('txt-documento');
                $extension = $file->getClientOriginalExtension();

                // Tomar el nombre del requisito
                $fileName = $item->requirement->id . '/' . $item->id . '.' . $extension;
                $path = $file->storeAs('requisitos', $fileName, 'public');

                // Actualizar el registro con la ruta del archivo
                $item->documento = 'public/' . $path;
                $item->save();
            }

            return response()->json(["status" => true, "mensaje" => 'Registro actualizado con éxito']);
        } catch (\Exception $e) {
            return response()->json(["status" => false, "mensaje" => 'Error al actualizar el registro.']);
        }
    }


    public function verDocumento($id)
    {
        $item = TeacherDocument::find($id);

        if ($item->documento == "--" || $item->documento == "") {
            $file = storage_path('app/public/sinImagen.jpg');
            return $this->viewFile($file);
        }

        $file = storage_path('app/') . $item->documento;

        if (file_exists($file)) {
            return $this->viewFile($file);
        } else {
            $file = storage_path('app/public/sinImagen.jpg');
            return $this->viewFile($file);
        }
    }

    public function viewFile($file)
    {
        $extension = pathinfo($file, PATHINFO_EXTENSION);

        // Verificar la extensión y establecer el tipo de contenido correspondiente
        switch ($extension) {
            case 'pdf':
                $contentType = 'application/pdf';
                break;
            case 'png':
                $contentType = 'image/png';
                break;
            case 'jpg':
            case 'jpeg':
                $contentType = 'image/jpeg';
                break;
            default:
                abort(404, 'Formato de archivo no admitido.');
        }

        $headers = [
            'Content-Type' => $contentType,
        ];

        $fileTitle = 'documento.' . $extension;
        return response()->download($file, $fileTitle, $headers, 'inline');
    }
}
