<?php

namespace App\Http\Controllers\docente;

use App\Http\Controllers\Controller;

use App\Models\Publicacion;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Yajra\DataTables\Facades\DataTables;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;
use Carbon\Carbon;
use Intervention\Image\Facades\Image;

class PublicacionesController extends Controller
{

    public function index(Request $request)
    {
        return view('docente.publicaciones.index');
    }


    public function list(Request $request)
    {
        $result = DB::table('publicacions as pu')
            ->leftJoin('programas as pro', 'pu.program_id', '=', 'pro.id')
            ->select([
                'pu.id',
                'pu.titulo',
                'pu.contenido',
                'pu.carpeta',
                'pu.imagen',
                'pu.created_at',
                'pu.dirigido_a',
                'pu.program_id',
                'pro.nombre as programa',
            ])
            ->where(function ($q) {
                $q->where('pu.dirigido_a', 'docente')
                    ->orWhere('pu.dirigido_a', 'ambos');
            })
            ->orderBy('pu.created_at', 'desc')
            ->get();

        return response()->json($result);
    }


    public function verImagen($idpublicacion, $carpeta, $imagen)
    {
        // Buscar la publicación por ID
        $item = Publicacion::find($idpublicacion);

        if (!$item || !$item->imagen) {
            abort(404, 'Imagen no encontrada.');
        }

        // Ruta completa del archivo de la imagen
        $file = storage_path('app/publicaciones/') . $carpeta . '/' . $imagen;

        if (file_exists($file)) {
            // Determinar el tipo MIME de la imagen
            $mimeType = mime_content_type($file);

            if (strpos($mimeType, 'image/') !== 0) {
                abort(400, 'El archivo no es una imagen válida.');
            }

            // Devolver la imagen como respuesta
            return response()->file($file, [
                'Content-Type' => $mimeType,
            ]);
        } else {
            abort(404, 'Archivo no encontrado.');
        }
    }
}
