<?php

namespace App\Http\Controllers\docente;

use App\Http\Controllers\Controller;

use App\Http\Controllers\sidebar\SidebarController;
use App\Models\Jpjob;
use App\Models\Jpjobapplication;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use Yajra\DataTables\Facades\DataTables;

class DocenteOfertasLaboralesController extends Controller
{
    //

    public function index(Request $request)
    {
        return view('docente.ofertas_laborales.index');
    }


    public function list(Request $request)
    {
        if ($request->ajax()) {
            // query
            $data = DB::table('bt_trabajos as job')
                ->join('bt_empresas as com', 'job.jpcompany_id', '=', 'com.id')
                ->join('bt_categorias as cat', 'job.jpcategory_id', '=', 'cat.id')
                ->join('ubigeos as ubi', 'job.ubigeo_id', '=', 'ubi.id')
                ->select(
                    'job.id as idjob',
                    'job.puesto',
                    'job.vacantes',
                    'job.tipo',
                    'job.modalidad',
                    'job.experiencia',
                    'job.fecpublicacion',
                    'job.feccierre',
                    'job.salariomin',
                    'job.salariomax',
                    'job.nivel_educativo',
                    'job.descripcion',
                    'job.estado',
                    'com.id as idcompany',
                    'com.nombre as nombrecompany',
                    'cat.id as idcategory',
                    'cat.nombre as nombrecategory',
                    'ubi.id as idubigeo',
                    DB::raw('SUBSTRING(ubi.id, 1, 2) as iddepartamento'),
                    'ubi.departamento',
                    DB::raw('SUBSTRING(ubi.id, 3, 2) as idprovincia'),
                    'ubi.provincia',
                    DB::raw('SUBSTRING(ubi.id, 5, 2) as iddistrito'),
                    'ubi.distrito'
                )
                ->whereDate('job.feccierre', '>=', now()->toDateString())
                ->get();
            // datatable
            return DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }

        return  response()->json(["status" => false, "mensaje" => 'No se puede cargar la información']);
    }


}
