<?php

namespace App\Http\Controllers\docente;

use App\Http\Controllers\Controller;
use App\Models\Semesterperiod;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Yajra\DataTables\Facades\DataTables;
use Illuminate\Support\Facades\Auth;

class DocenteHorariosController extends Controller
{
    public function index()
    {
        return view('docente.horarios.index');
    }

    public function list_info_semestres(Request $request, $idplan)
    {
        try {
            $user = Auth::User();
            $docentedata = $user->teachers;
            $iddocente = $docentedata[0]->id;

            if ($request->ajax()) {

                $result = Semesterperiod::select('periodos.id', 'periodos.numero AS periodos')
                    ->join('semestres', 'semestres.id', '=', 'periodos_semestres.semester_id')
                    ->join('asignaturas', 'semestres.id', '=', 'asignaturas.semester_id')
                    ->join('periodos', 'periodos.id', '=', 'periodos_semestres.period_id')
                    ->distinct()
                    ->where('asignaturas.teacher_id', '=', $iddocente)
                    ->where('periodos.plan_id', '=', $idplan)
                    ->orderBy('periodos')
                    ->get();

                return response()->json($result);
            } else {
                return response()->json([
                    'estado' => false,
                    'mensaje' => "error de consulta",
                ]);
            }
        } catch (Exception $e) {
            return response()->json([
                'estado' => false,
                'type' => 'Catch',
                'mensaje' => $e,
            ]);
        }
    }

    public function list_horario_docente(Request $request)
    {
        if ($request->ajax()) {
            $idsemester = $request->input('idsemester');
            $user = Auth::user();
            $iddocente = $user->teachers->first()->id;

            // 1) HORARIO DE CLASES
            $data = DB::table('asignaturas as a')
                ->join('semestres as s', 's.id', '=', 'a.semester_id')
                ->leftJoin('horarios as h', 'h.subject_id', '=', 'a.id')
                ->leftJoin('aulas as au', 'au.id', '=', 'h.classroom_id')
                ->join('cursos as c', 'c.id', '=', 'a.course_id')
                ->join('periodos as p', 'p.id', '=', 'c.period_id')
                ->join('planes as pl', 'pl.id', '=', 'p.plan_id')
                ->join('programas as pr', 'pr.id', '=', 'pl.program_id')
                ->select([
                    'pr.nombre as programa',
                    'pl.nombre as plan',
                    'p.numero as periodo',
                    'c.codcurso',
                    'c.nombre as curso',
                    'c.tipo',
                    'a.tipo as condicion',
                    'a.turno',
                    'a.seccion',
                    DB::raw('COALESCE(GROUP_CONCAT(CASE WHEN h.dia = "Lunes" THEN CONCAT(TIME_FORMAT(h.horaini, "%H:%i"), " - ", TIME_FORMAT(h.horafin, "%H:%i")) END), "-") AS Lunes'),
                    DB::raw('COALESCE(GROUP_CONCAT(CASE WHEN h.dia = "Martes" THEN CONCAT(TIME_FORMAT(h.horaini, "%H:%i"), " - ", TIME_FORMAT(h.horafin, "%H:%i")) END), "-") AS Martes'),
                    DB::raw('COALESCE(GROUP_CONCAT(CASE WHEN h.dia = "Miercoles" THEN CONCAT(TIME_FORMAT(h.horaini, "%H:%i"), " - ", TIME_FORMAT(h.horafin, "%H:%i")) END), "-") AS Miercoles'),
                    DB::raw('COALESCE(GROUP_CONCAT(CASE WHEN h.dia = "Jueves" THEN CONCAT(TIME_FORMAT(h.horaini, "%H:%i"), " - ", TIME_FORMAT(h.horafin, "%H:%i")) END), "-") AS Jueves'),
                    DB::raw('COALESCE(GROUP_CONCAT(CASE WHEN h.dia = "Viernes" THEN CONCAT(TIME_FORMAT(h.horaini, "%H:%i"), " - ", TIME_FORMAT(h.horafin, "%H:%i")) END), "-") AS Viernes'),
                    DB::raw('COALESCE(GROUP_CONCAT(CASE WHEN h.dia = "Sabado" THEN CONCAT(TIME_FORMAT(h.horaini, "%H:%i"), " - ", TIME_FORMAT(h.horafin, "%H:%i")) END), "-") AS Sabado'),
                    DB::raw("COALESCE(au.numero, '-') as aula"),
                ])
                ->where('a.teacher_id', $iddocente)
                ->where('s.id', $idsemester)
                ->groupBy([
                    'pr.nombre',
                    'pl.nombre',
                    'p.numero',
                    'c.codcurso',
                    'c.nombre',
                    'c.tipo',
                    'a.tipo',
                    'a.turno',
                    'a.seccion',
                    'au.numero',
                ])
                ->orderBy('p.numero')
                ->get();

            // 2) FOROS DEL DOCENTE
            // Queremos todos los foros de las asignaturas de este docente en este semestre.
            $foros = DB::table('foros as f')
                ->join('asignaturas as a', 'a.id', '=', 'f.subject_id')
                ->join('docentes as d', 'd.id', '=', 'a.teacher_id')
                ->join('cursos as c', 'c.id', '=', 'a.course_id')
                ->join('semestres as s', 's.id', '=', 'a.semester_id')
                ->select(
                    'f.id as idforum',
                    'f.titulo as titulo',
                    'f.descripcion as descripcion',
                    'f.fecinicio as fecinicio',
                    'f.fecfin as fecfin',
                    'c.codcurso as codcurso',
                    'c.nombre as curso',
                    DB::raw("
                        -- Fin redondeado al cuarto más cercano
                        DATE_FORMAT(
                            DATE_ADD(
                                DATE_SUB(
                                    f.fecfin,
                                    INTERVAL (MINUTE(f.fecfin) % 15) MINUTE
                                ),
                                INTERVAL 
                                    CASE 
                                        WHEN MINUTE(f.fecfin) % 15 >= 8 THEN 15
                                        ELSE 0
                                    END MINUTE
                            ),
                            '%Y-%m-%d %H:%i:00'
                        ) AS end_calendar,

                        -- Inicio = fin redondeado - 1 hora
                        DATE_FORMAT(
                            DATE_SUB(
                                DATE_ADD(
                                    DATE_SUB(
                                        f.fecfin,
                                        INTERVAL (MINUTE(f.fecfin) % 15) MINUTE
                                    ),
                                    INTERVAL 
                                        CASE 
                                            WHEN MINUTE(f.fecfin) % 15 >= 8 THEN 15
                                            ELSE 0
                                        END MINUTE
                                ),
                                INTERVAL 1 HOUR
                            ),
                            '%Y-%m-%d %H:%i:00'
                        ) AS start_calendar
                    ")
                )
                ->where('d.id', $iddocente)
                ->where('s.id', $idsemester)
                ->orderBy('f.fecinicio')
                ->get();

            // 3) RESPUESTA
            // Yajra DataTables permite adjuntar datos extra con ->with()
            return DataTables::of($data)
                ->addIndexColumn()
                ->with('foros', $foros)
                ->make(true);
        }

        return response()->json([
            "status" => false,
            "mensaje" => 'Error: no s pueden cargar los archivos',
        ]);
    }
}
