<?php

namespace App\Http\Controllers\alumno;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\Models\Subjectenrollment;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Yajra\DataTables\Facades\DataTables;
use Carbon\Carbon;

class SubjectenrollmentController extends Controller
{
    //
    public function index(Request $request)
    {
        return view('alumno.matricula.index');
    }

    public function list(Request $request)
    {
        $idsemester = $request->input('idsemester');
        $idstudent  = Auth::user()->students[0]->id;
        $planId     = Auth::user()->students[0]->plan_id ?? null;

        if ($request->ajax()) {
            // query
            $data = DB::table('asignaturas as su')
                ->join('matriculas_semestres as seen', 'su.semester_id', '=', 'seen.semester_id')
                ->join('matriculas_asignaturas as suen', function ($join) {
                    $join->on('su.id', '=', 'suen.subject_id')
                        ->on('seen.student_id', '=', 'suen.student_id');
                })
                ->join('cursos as co', 'su.course_id', '=', 'co.id')
                ->join('periodos as pe', 'co.period_id', '=', 'pe.id')
                ->select(
                    'su.id as idsubject',
                    'suen.id as idsubjectenrollment',
                    'pe.numero as periodo',
                    'co.tipo as tipo_curso',
                    'co.codcurso',
                    'co.nombre as curso',
                    'co.horas',
                    'co.creditos',
                    'su.seccion',
                    'su.turno',
                    'su.tipo as tipo_asignatura'
                )
                ->where('su.semester_id', $idsemester)
                ->where('seen.student_id', $idstudent)
                ->where('pe.plan_id', $planId)
                ->orderBy('pe.numero', 'ASC')
                ->orderBy('co.nombre', 'ASC')
                ->get();
                
            // datatable    
            return DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }
        
        return  response()->json(["status" => false, "mensaje" => 'No se pueden cargar los datos']);
    }


    public function list_available_courses(Request $request)
    {
        $idsemester = $request->input('idsemester');
        $periodId   = $request->input('period_id');
        $idstudent  = Auth::user()->students[0]->id;
        $planId     = Auth::user()->students[0]->plan_id ?? null;
        
        if ($request->ajax()) {
            $data = DB::table('asignaturas as su')
                ->join('matriculas_semestres as seen', 'su.semester_id', '=', 'seen.semester_id')
                ->leftJoin('matriculas_asignaturas as suen', function ($join) {
                    $join->on('su.id', '=', 'suen.subject_id')
                        ->on('seen.student_id', '=', 'suen.student_id');
                })
                ->join('cursos as co', 'su.course_id', '=', 'co.id')
                ->join('periodos as pe', 'co.period_id', '=', 'pe.id')
                ->select(
                    'su.id as idsubject',
                    DB::raw('COALESCE(suen.id, 0) as idsubjectenrollment'),
                    'pe.numero as periodo',
                    'pe.id as period_id',     
                    'co.tipo as tipo_curso',
                    'co.codcurso',
                    'co.nombre as curso',
                    'co.horas',
                    'co.creditos',
                    'su.seccion',
                    'su.turno',
                    'su.tipo as tipo_asignatura'
                )
                ->where('su.semester_id', $idsemester)
                ->when($planId, function ($q) use ($planId) { 
                    $q->where('pe.plan_id', $planId);
                })
                ->whereNull('suen.id') 
                ->where('seen.student_id', $idstudent)
                ->where('pe.id', $periodId)
                ->orderBy('pe.numero', 'ASC')
                ->orderBy('co.nombre', 'ASC')
                ->get();
                
            return DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }
        
        return response()->json(["status" => false, "mensaje" => 'No se pueden cargar los datos']);
    }


    public function store(Request $request)
    {
        $idstudent = Auth::user()->students[0]->id;
        
        // $data_semester = DB::table('semestres AS se')
        //     ->select('se.estado_matricula', 'se.fecfin')
        //     ->where('se.id', $request->input('txt-idsemester'))
        //     ->first();
        
        // $fechaFinSemestre = Carbon::parse($data_semester->fecfin);
        // $fechaActual      = Carbon::now();
        
        // Si el estado de matrícula del semestre está deshabilitado
        // if ($data_semester->estado_matricula == 0) {
        //     return response()->json(["status" => false, "mensaje" => 'Las matriculas estan deshabilitadas']);
        // }
        
        // Si la fecha actual es mayor a la fecha de fin del semestre
        // if ($fechaActual->gt($fechaFinSemestre)) {
        //     return response()->json(["status" => false, "mensaje" => 'La matrícula para este semestre ha expirado']);
        // }
        
        $curso = DB::table('cursos as c')
            ->join('asignaturas as a', 'a.course_id', '=', 'c.id')
            ->select('a.id as idasignatura', DB::raw('SUM(c.creditos) as creditos'))
            ->where('a.id', $request->input('txt-idsubject'))
            ->groupBy('a.id')
            ->first();
        
        $creditos = DB::table('cursos as c')
            ->join('asignaturas as a', 'a.course_id', '=', 'c.id')
            ->join('matriculas_asignaturas as ma', 'ma.subject_id', '=', 'a.id')
            ->join('semestres as s', 's.id', '=', 'a.semester_id')
            ->join('matriculas_semestres as ms', function ($join) {
                $join->on('ms.student_id', '=', 'ma.student_id')
                    ->on('ms.semester_id', '=', 's.id');
            })
            ->select('ms.student_id as idstudent', 'ms.id as idmatricula_semestre', DB::raw('SUM(c.creditos) as total'))
            ->where('ms.semester_id', $request->input('txt-idsemester'))
            ->where('ms.student_id', $idstudent)
            ->groupBy('ms.student_id', 'ms.id')
            ->first();
            
        if (!$creditos) {
            $subtotal_creditos = 0;
        } else {
            $subtotal_creditos = $creditos->total;
        }
        
        // Si los créditos no superan 19, permite registrar
        if (($subtotal_creditos + $curso->creditos) <= 19) {
            $item = new Subjectenrollment();
            $item->student_id = $idstudent;
            $item->subject_id = $request->input('txt-idsubject');
            $item->estado     = '2';
            
            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Registro insertado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no insertado']);
            }
        } else {
            return response()->json(["status" => false, "mensaje" => 'El limite de créditos por semestre es 19']);
        }
    }

    public function destroy($idsubjectenrollment)
    {
        // Busca el registro por su ID
        $item = Subjectenrollment::find($idsubjectenrollment);

        // Verifica si el registro existe
        if (!$item) {
            return response()->json(["status" => false, "mensaje" => 'El registro no existe']);
        }

        // Elimina el registro de la base de datos
        if ($item->delete()) {
            return response()->json(["status" => true, "mensaje" => 'El registro fue eliminado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'El registro no fue eliminado']);
        }
    }



    public function periods(Request $request, $idsemester)
    {
        $planId     = Auth::user()->students[0]->plan_id ?? null;

        // Periodos disponibles en función de las asignaturas/cursos del semestre
        $query = DB::table('periodos as pe')
            ->join('cursos as co', 'co.period_id', '=', 'pe.id')
            ->join('asignaturas as su', 'su.course_id', '=', 'co.id')
            ->select('pe.id', 'pe.numero');

        if ($idsemester) {
            $query->where('su.semester_id', $idsemester);
        }

        if ($planId) {
            $query->where('pe.plan_id', $planId);
        }

        $periodos = $query->distinct()
            ->orderBy('pe.numero', 'ASC')
            ->get();

        return response()->json($periodos);
    }
}
