<?php

namespace App\Http\Controllers\alumno;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use App\Models\Publicacion;

class PublicacionesController extends Controller
{
    public function index(Request $request)
    {
        $result = DB::table('estudiantes as e')
            ->join('usuarios as u', 'u.id', '=', 'e.user_id')
            ->join('planes as pl', 'pl.id', '=', 'e.plan_id')
            ->join('programas as pro', 'pro.id', '=', 'pl.program_id') // planes → programas
            ->join('publicacions as pu', 'pu.program_id', '=', 'pro.id') // publicacions → programas
            ->select([
                'e.id as idstudent',
                'u.id as iduser',
                'u.estado as estado',
                'pl.id as plaid',
                'pl.nombre as plan_nombre',
                'pro.id as program_id',
                'pro.nombre as programa',
                'pu.id as publicacion_id',
                'pu.titulo',
                'pu.contenido',
                'pu.carpeta',
                'pu.imagen',
                'pu.created_at'
            ])
            ->where('u.estado', 1)
            ->where('u.id', Auth::user()->id)
            ->orderBy('pu.created_at', 'desc')
            ->get();

        return view('alumno.publicaciones.index')
            ->with('data', $result);
    }

    public function list()
    {
        $user = Auth::user();

        // Traer al estudiante logueado con su programa
        $student = DB::table('estudiantes as e')
            ->join('planes as pl', 'pl.id', '=', 'e.plan_id')
            ->join('programas as pro', 'pro.id', '=', 'pl.program_id')
            ->where('e.user_id', $user->id)
            ->select('pro.id as program_id')
            ->first();

        if (!$student) {
            return response()->json([]);
        }

        $programId = $student->program_id;

        $result = DB::table('publicacions as pu')
            ->leftJoin('programas as pro', 'pu.program_id', '=', 'pro.id') // LEFT JOIN para no excluir nulos
            ->select([
                'pu.id',
                'pu.titulo',
                'pu.contenido',
                'pu.carpeta',
                'pu.imagen',
                'pu.created_at',
                'pu.dirigido_a',
                'pu.program_id',
                'pro.nombre as programa',
            ])
            ->where(function ($q) use ($programId) {
                $q->where('pu.program_id', $programId)   // Coincide con el programa del estudiante
                    ->orWhereNull('pu.program_id');        // O es nulo → aplica a todos
            })
            ->where(function ($q) {
                $q->where('pu.dirigido_a', 'estudiante')
                    ->orWhere('pu.dirigido_a', 'ambos');
            })
            ->orderBy('pu.created_at', 'desc')
            ->get();

        return response()->json($result);
    }

    public function verImagen($idpublicacion, $carpeta, $imagen)
    {
        // Buscar la publicación por ID
        $item = Publicacion::find($idpublicacion);

        if (!$item || !$item->imagen) {
            abort(404, 'Imagen no encontrada.');
        }

        // Ruta completa del archivo de la imagen
        $file = storage_path('app/publicaciones/') . $carpeta . '/' . $imagen;

        if (file_exists($file)) {
            // Determinar el tipo MIME de la imagen
            $mimeType = mime_content_type($file);

            if (strpos($mimeType, 'image/') !== 0) {
                abort(400, 'El archivo no es una imagen válida.');
            }

            // Devolver la imagen como respuesta
            return response()->file($file, [
                'Content-Type' => $mimeType,
            ]);
        } else {
            abort(404, 'Archivo no encontrado.');
        }
    }
}
