<?php

namespace App\Http\Controllers\alumno;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Yajra\DataTables\Facades\DataTables;

class NotaController extends Controller
{

    //
    public function index(Request $request)
    {
        return view('alumno.notas.index');
    }

    public function list_nota(Request $request)
    {
        if ($request->ajax()) {

            $idsemester = $request->input('idsemester');

            $user = Auth::user();
            $studentdata = $user->students;
            $idstudent = $studentdata[0]->id;

            $gradesQuery = DB::table('matriculas_asignaturas AS ma')
            ->selectRaw('
                a.id AS idsubject,
                ma.student_id AS idstudent,
                pl.nombre AS plan,
                c.codcurso AS codcurso,
                c.nombre AS curso,
                c.tipo AS tipo,
                CONCAT("Crd: ", c.creditos, " - Hrs: ", c.horas) AS creditos_horas,
                pe.numero AS periodo,
                a.tipo AS condicion,
                a.seccion AS seccion,
                a.turno AS turno,
                i.id AS idindicator,
                ac.id AS idactivity,
                n.id AS idgrade,
                n.nombre AS tipo_nota,
                n.porcentaje AS porcentaje,
                ne.id AS idstudentgrade,
                COALESCE(ROUND(SUM(ne.nota) / COUNT(ne.id), 2), 0) AS nota
            ')
            ->join('asignaturas AS a', 'a.id', '=', 'ma.subject_id')
            ->join('cursos AS c', 'c.id', '=', 'a.course_id')
            ->join('periodos AS pe', 'pe.id', '=', 'c.period_id')
            ->join('planes AS pl', 'pl.id', '=', 'pe.plan_id')
            ->join('semestres AS se', 'se.id', '=', 'a.semester_id')
            ->leftJoin('indicadores AS i', 'i.subject_id', '=', 'a.id')
            ->leftJoin('actividades AS ac', 'ac.indicator_id', '=', 'i.id')
            ->leftJoin('notas AS n', 'n.activity_id', '=', 'ac.id')
            ->leftJoin('notas_estudiantes AS ne', function ($join) {
                $join->on('ne.grade_id', '=', 'n.id')
                    ->on('ne.subjectenrollment_id', '=', 'ma.id');
            })
            ->where('ma.student_id', '=', $idstudent)
            ->where('se.id', '=', $idsemester)
            ->groupBy('plan', 'curso', 'codcurso', 'tipo', 'creditos_horas', 'periodo', 'condicion',
            'seccion', 'turno', 'idindicator', 'idactivity', 'idgrade', 'idstudentgrade',
            'tipo_nota', 'porcentaje', 'idsubject', 'idstudent');

            // Subconsulta para promedios por actividad
            $activityQuery = DB::table(DB::raw('(' . $gradesQuery->toSql() . ') AS subconsulta_2'))
            ->mergeBindings($gradesQuery)
            ->groupBy('plan', 'curso', 'codcurso', 'tipo', 'creditos_horas', 'periodo', 'condicion', 'seccion', 'turno', 'idindicator', 'idactivity', 'idsubject', 'idstudent')
            ->selectRaw('
                idsubject,
                idstudent,
                plan,
                codcurso,
                curso,
                tipo,
                creditos_horas,
                periodo,
                condicion,
                seccion,
                turno,
                idindicator,
                idactivity,
                COALESCE(ROUND(SUM(nota * porcentaje), 2), 0) AS promedio_actividades
            ');

            // Subconsulta para promedios por indicador
            $indicatorQuery = DB::table(DB::raw('(' . $activityQuery->toSql() . ') AS subconsulta_3'))
            ->mergeBindings($activityQuery)
            ->groupBy('plan', 'curso', 'codcurso', 'tipo', 'creditos_horas', 'periodo', 'condicion', 'seccion', 'turno', 'idindicator', 'idsubject', 'idstudent')
            ->selectRaw('
                idsubject,
                idstudent,
                plan,
                codcurso,
                curso,
                tipo,
                creditos_horas,
                periodo,
                condicion,
                seccion,
                turno,
                idindicator,
                COALESCE(ROUND(SUM(promedio_actividades) / COUNT(idactivity), 2), 0) AS promedio_indicadores
            ');

            // Consulta final
            $promedios = DB::table(DB::raw('(' . $indicatorQuery->toSql() . ') AS subconsulta_4'))
            ->mergeBindings($indicatorQuery)
            ->groupBy('plan', 'curso', 'codcurso', 'tipo', 'creditos_horas', 'periodo', 'condicion', 'seccion', 'turno', 'idsubject', 'idstudent')
            ->selectRaw('
                idsubject,
                idstudent,
                plan,
                periodo,
                codcurso,
                curso,
                tipo,
                creditos_horas,
                condicion,
                seccion,
                turno,
                COALESCE(ROUND(SUM(promedio_indicadores) / COUNT(idindicator), 0), 0) AS nota
            ')
            ->get();

            // datatable
            return DataTables::of($promedios)
                ->addIndexColumn()
                ->make(true);
        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los archivos'
        ]);
    }

    public function list_promedio_estudiante(Request $request)
    {
        if ($request->ajax()) {

            $idsubject = $request->input('idsubject');
            $idstudent = $request->input('idstudent');

            $query = "
            WITH NotasPorTipo AS (
                SELECT
                    i.id AS indicador_id,
                    ac.id AS actividad_id,
                    i.nombre AS indicador,
                    ac.nombre AS actividad,
                    n.nombre AS nombre_nota,
                    n.porcentaje AS porcentaje,
                    COALESCE(ROUND(ne.nota, 1), 0) AS nota_estudiante
                FROM estudiantes AS e
                INNER JOIN matriculas_asignaturas AS ma ON e.id = ma.student_id
                INNER JOIN asignaturas AS a ON ma.subject_id = a.id
                LEFT JOIN indicadores AS i ON a.id = i.subject_id
                LEFT JOIN actividades AS ac ON i.id = ac.indicator_id
                LEFT JOIN notas AS n ON ac.id = n.activity_id
                LEFT JOIN notas_estudiantes AS ne ON ne.grade_id = n.id AND ne.subjectenrollment_id = ma.id
                WHERE a.id = :subjectId AND e.id = :studentId
                GROUP BY i.id, ac.id, i.nombre, ac.nombre, n.porcentaje, n.nombre, ne.nota, ne.id
                ORDER BY i.nombre, ac.nombre, n.nombre
            ),

            PromedioPorActividad AS (
                SELECT
                    indicador_id,
                    actividad_id,
                    indicador,
                    actividad,
                    COALESCE(ROUND(SUM(nota_estudiante * porcentaje) / SUM(porcentaje), 2), 0) AS prom_actividad
                FROM NotasPorTipo
                GROUP BY indicador_id, actividad_id, indicador, actividad
                ORDER BY indicador, actividad
            ),

            PromedioPorIndicador AS (
                SELECT
                    indicador_id,
                    indicador,
                    ROUND(SUM(prom_actividad) / COUNT(actividad_id), 2) AS prom_indicador
                FROM PromedioPorActividad
                GROUP BY indicador_id, indicador
                ORDER BY indicador
            ),

            PromedioFinal AS (
                SELECT
                    ROUND(SUM(prom_indicador) / COUNT(indicador_id), 2) AS prom_final
                FROM
                    PromedioPorIndicador
            )

            SELECT
                COALESCE (npt.indicador, '--') as indicador,
                COALESCE (npt.actividad, '--') as actividad,
                COALESCE (npt.porcentaje, '--') as porcentaje,
                COALESCE (npt.nombre_nota, '--') as nombre_nota,
                COALESCE (npt.nota_estudiante, '--') as nota_estudiante,
                COALESCE (ppa.prom_actividad, '--') as prom_actividad,
                COALESCE (ppi.prom_indicador, '--') as prom_indicador,
                COALESCE (pf.prom_final, '--') as prom_final
            FROM NotasPorTipo AS npt
            LEFT JOIN PromedioPorActividad AS ppa
                ON npt.indicador_id = ppa.indicador_id
                AND npt.actividad_id = ppa.actividad_id
            LEFT JOIN PromedioPorIndicador AS ppi
                ON npt.indicador_id = ppi.indicador_id
            JOIN PromedioFinal AS pf
            ORDER BY npt.indicador, npt.actividad, npt.porcentaje;
            ";

        $result = DB::select($query, ['subjectId' => $idsubject, 'studentId' => $idstudent]);

            // datatable
            return DataTables::of($result)
                ->addIndexColumn()
                ->make(true);
        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar la información'
        ]);
    }
}
