<?php

namespace App\Http\Controllers\alumno;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;
use App\Models\Folder;
use App\Models\Subfolder;
use App\Models\Folderfile;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Storage;
use Yajra\DataTables\Facades\DataTables;

class MaterialesRecursosController extends Controller
{
    //
    public function index(Request $request)
    {
        return view('alumno.materiales_recursos.index');
    }

    public function list_subjects(Request $request, $idsemester)
    {
        if ($request->ajax()) {

            $idUsuario = Auth::User()->id;

            $data = DB::table('asignaturas as a')
                ->select('a.id as id', 'a.seccion', 'a.turno', 'cu.id as idcourse', 'cu.codcurso', 'cu.nombre as namecurso')
                ->join('cursos as cu', 'a.course_id', '=', 'cu.id')
                ->join('matriculas_asignaturas as ma', 'ma.subject_id', '=', 'a.id')
                ->join('estudiantes as e', 'e.id', '=', 'ma.student_id')
                ->join('matriculas_semestres as ms', function($join) {
                    $join->on('ms.student_id', '=', 'e.id')
                        ->whereColumn('ms.semester_id', '=', 'a.semester_id');
                })
                ->where('e.user_id', $idUsuario)
                ->where('a.semester_id', $idsemester)
                ->orderBy('cu.nombre')
                ->get();

            return response()->json($data);
        }
        return  response()->json(["status" => false, "mensaje" => 'Error en request']);
    }

    public function list_folders(Request $request, $idsubject)
    {
        if ($request->ajax()) {

            DB::statement("SET lc_time_names = 'es_ES'");

            $data = DB::table('carpetas as c')
                ->select(
                    'c.subject_id as idsubject',
                    'c.id as idfolder',
                    'c.nombre as nombre',
                    'c.descripcion as descripcion',
                    'c.estado as estado',
                    DB::raw("DATE_FORMAT(c.updated_at, '%d de %M, %Y') AS fecha"),
                    DB::raw("DATE_FORMAT(c.updated_at, '%H:%i %p') AS hora")
                    )
                ->where('c.subject_id', $idsubject)
                ->get();

            return response()->json($data);
        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los archivos'
        ]);
    }


    public function list_subfolders(Request $request, $idfolder)
    {
        if ($request->ajax()) {
            $data = DB::table('subcarpetas as s')
                ->select(
                    's.id as idsubfolder',
                    's.folder_id as idfolder',
                    's.nombre as nombre',
                    DB::raw("DATE_FORMAT(s.updated_at, '%d de %M, %Y') AS fecha"),
                    DB::raw("DATE_FORMAT(s.updated_at, '%H:%i %p') AS hora")
                    )
                ->where('s.folder_id', $idfolder)
                ->get();

            return response()->json($data);
        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los archivos'
        ]);
    }


    public function list_folderfiles(Request $request, $idsubfolder)
    {
        if ($request->ajax()) {
            $data = DB::table('archivos_carpetas AS ac')
                ->join('subcarpetas AS s', 's.id', '=', 'ac.subfolder_id')
                ->join('carpetas AS c', 'c.id', '=', 's.folder_id')
                ->join('asignaturas AS a', 'a.id', '=', 'c.subject_id')
                ->select(
                    'a.id AS idsubject',
                    'c.id AS idfolder',
                    's.id AS idsubfolder',
                    'ac.id AS idfolderfile',
                    'ac.ruta AS ruta',
                    'ac.archivo AS archivo',
                    DB::raw("DATE_FORMAT(ac.created_at, '%d de %M, %Y') AS fecha"),
                    DB::raw("DATE_FORMAT(ac.created_at, '%H:%i %p') AS hora")
                )
                ->where('ac.subfolder_id', '=', $idsubfolder)
                ->get();

             // Agregar el tamaño de cada archivo al resultado
            foreach ($data as $file) {
                $filePath = $file->ruta;
                $fileSize = Storage::size($filePath);
                // Convertir a kilobytes
                $file->tamaño = number_format($fileSize / 1024, 0, '.', ',');
            }

            return response()->json($data);
        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los archivos'
        ]);
    }

    public function download_folderfile($idfolderfile)
    {
        // Buscar la ruta del archivo en la base de datos
        $item =  Folderfile::find($idfolderfile);

        // recuperar data
        $ruta = $item->ruta;

        // Verificar si la ruta del archivo existe
        if ($ruta) {
            // Obtener la ruta completa al archivo en el almacenamiento
            $rutaCompleta = Storage::path($ruta);

            // Verificar si el archivo existe en el almacenamiento
            if (Storage::exists($ruta)) {

                // Devolver el archivo como una descarga
                return response()->download($rutaCompleta, $item->archivo);
            } else {
                // Si el archivo no existe, devolver una respuesta JSON con un mensaje de error
                return response()->json([
                    "status" => false,
                    "mensaje" => 'El archivo no existe en el almacenamiento'
                ]);
            }
        } else {
            // Si no se encuentra la ruta del archivo en la base de datos, devolver un mensaje de error
            return response()->json([
                "status" => false,
                "mensaje" => 'La ruta del archivo no está disponible'
            ]);
        }
    }

    public function subjects_semesters(Request $request)
    {
        if ($request->ajax()) {

            $idUsuario = Auth::User()->id;

            $data = Folderfile::select(
                'asignaturas.id AS id',
                'asignaturas.seccion',
                'asignaturas.turno',
                'cu.id AS idcourse',
                'cu.codcurso',
                'cu.nombre AS namecurso')
            ->join('cursos AS cu', 'asignaturas.course_id', '=', 'cu.id')
            ->join('docentes AS doc', 'asignaturas.teacher_id', '=', 'doc.id')
            ->join('usuarios AS us', 'doc.user_id', '=', 'us.id')
            ->where('us.id', $idUsuario)
            ->get();
            return response()->json($data);
        }
        return  response()->json(["status" => false, "mensaje" => 'Error en request']);
    }

}
