<?php

namespace App\Http\Controllers\alumno;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Yajra\DataTables\Facades\DataTables;

class HorarioController extends Controller
{
    public function index()
    {
        return view('alumno.horarios.index');
    }

    public function list_info(Request $request)
    {
        $user = Auth::user();
        $studentdata = $user->students;
        $idstudent = $studentdata[0]->id;

        if ($request->ajax()) {
            DB::statement("SET lc_time_names = 'es_ES'");

            $data = DB::table('estudiantes as st')
                ->select(
                    'st.id as idstudent',
                    'st.user_id as iduser',
                    'pr.codprograma',
                    'pr.nombre as programa',
                    'pr.nivel_formativo',
                    'pl.nombre as plan',
                    'pl.tipo',
                    'pl.modalidad',
                    'pl.enfoque',
                    // DB::raw('CONCAT(se.anho, "-", se.numero) as semestre'),
                    // DB::raw('DATE_FORMAT(se.fecinicio, "%d - %M") as fecinicio'),
                    // DB::raw('DATE_FORMAT(se.fecfin, "%d - %M") as fecfin')
                )
                ->join('planes as pl', 'pl.id', '=', 'st.plan_id')
                ->join('programas as pr', 'pr.id', '=', 'pl.program_id')
                // ->join('matriculas_semestres as seen', 'seen.student_id', '=', 'st.id')
                // ->join('semestres as se', 'se.id', '=', 'seen.semester_id')
                ->where('st.id', '=', $idstudent)
                // ->where('se.id', '=', $idsemester)
                ->get();

            return response()->json($data);
        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error en request'
        ]);
    }

    public function list_horario(Request $request)
    {
        if ($request->ajax()) {
            $idsemester = $request->input('idsemester');
            $user = Auth::user();
            $idestudiante = $user->students->first()->id;

            // 1) HORARIO DE CLASES
            $data = DB::table('asignaturas AS a')
                ->leftJoin('docentes AS d', 'd.id', '=', 'a.teacher_id')
                ->leftJoin('usuarios AS u', 'u.id', '=', 'd.user_id')
                ->join('matriculas_asignaturas AS ma', 'a.id', '=', 'ma.subject_id')
                ->join('estudiantes AS e', 'e.id', '=', 'ma.student_id')
                ->join('semestres AS s', 's.id', '=', 'a.semester_id')
                ->leftJoin('horarios AS h', 'h.subject_id', '=', 'a.id')
                ->leftJoin('aulas AS au', 'au.id', '=', 'h.classroom_id')
                ->join('cursos AS c', 'c.id', '=', 'a.course_id')
                ->join('periodos AS p', 'p.id', '=', 'c.period_id')
                ->join('planes AS pl', 'pl.id', '=', 'p.plan_id')
                ->select(
                    'c.codcurso',
                    'c.nombre AS curso',
                    'c.tipo',
                    'a.tipo AS condicion',
                    'a.turno',
                    'a.seccion',
                    'p.numero AS periodo',
                    DB::raw('COALESCE(GROUP_CONCAT(CASE WHEN h.dia = "Lunes" THEN CONCAT(TIME_FORMAT(h.horaini, "%H:%i"), " - ", TIME_FORMAT(h.horafin, "%H:%i")) END), "-") AS Lunes'),
                    DB::raw('COALESCE(GROUP_CONCAT(CASE WHEN h.dia = "Martes" THEN CONCAT(TIME_FORMAT(h.horaini, "%H:%i"), " - ", TIME_FORMAT(h.horafin, "%H:%i")) END), "-") AS Martes'),
                    DB::raw('COALESCE(GROUP_CONCAT(CASE WHEN h.dia = "Miercoles" THEN CONCAT(TIME_FORMAT(h.horaini, "%H:%i"), " - ", TIME_FORMAT(h.horafin, "%H:%i")) END), "-") AS Miercoles'),
                    DB::raw('COALESCE(GROUP_CONCAT(CASE WHEN h.dia = "Jueves" THEN CONCAT(TIME_FORMAT(h.horaini, "%H:%i"), " - ", TIME_FORMAT(h.horafin, "%H:%i")) END), "-") AS Jueves'),
                    DB::raw('COALESCE(GROUP_CONCAT(CASE WHEN h.dia = "Viernes" THEN CONCAT(TIME_FORMAT(h.horaini, "%H:%i"), " - ", TIME_FORMAT(h.horafin, "%H:%i")) END), "-") AS Viernes'),
                    DB::raw('COALESCE(GROUP_CONCAT(CASE WHEN h.dia = "Sabado" THEN CONCAT(TIME_FORMAT(h.horaini, "%H:%i"), " - ", TIME_FORMAT(h.horafin, "%H:%i")) END), "-") AS Sabado'),
                    DB::raw('COALESCE(CONCAT(u.nombres, " ", u.apellido_pa, " ", u.apellido_ma), "-") AS docente'),
                    DB::raw('COALESCE(au.numero, "-") AS aula')
                )
                ->where('s.id', $idsemester)
                ->where('e.id', $idestudiante)
                ->groupBy(
                    'c.codcurso',
                    'c.nombre',
                    'c.tipo',
                    'condicion',
                    'a.turno',
                    'a.seccion',
                    'p.numero',
                    's.id',
                    'd.user_id',
                    'docente',
                    'aula'
                )
                ->get();

            // 2) HORARIO DE FOROS DEL ESTUDIANTE (misma lógica que el docente, pero filtrando por estudiante)
            $foros = DB::table('foros as f')
                ->join('asignaturas as a', 'a.id', '=', 'f.subject_id')
                ->join('matriculas_asignaturas AS ma', 'ma.subject_id', '=', 'a.id')
                ->join('estudiantes AS e', 'e.id', '=', 'ma.student_id')
                ->join('cursos as c', 'c.id', '=', 'a.course_id')
                ->join('semestres as s', 's.id', '=', 'a.semester_id')
                ->select(
                    'f.id as idforum',
                    'f.titulo as titulo',
                    'f.descripcion as descripcion',
                    'f.fecinicio as fecinicio',
                    'f.fecfin as fecfin',
                    'c.codcurso as codcurso',
                    'c.nombre as curso',
                    // fin redondeado al cuarto de hora más cercano
                    DB::raw("
                        DATE_FORMAT(
                            DATE_ADD(
                                DATE_SUB(
                                    f.fecfin,
                                    INTERVAL (MINUTE(f.fecfin) % 15) MINUTE
                                ),
                                INTERVAL 
                                    CASE 
                                        WHEN MINUTE(f.fecfin) % 15 >= 8 THEN 15
                                        ELSE 0
                                    END MINUTE
                            ),
                            '%Y-%m-%d %H:%i:00'
                        ) AS end_calendar
                    "),
                        // inicio = fin redondeado - 1 hora
                        DB::raw("
                        DATE_FORMAT(
                            DATE_SUB(
                                DATE_ADD(
                                    DATE_SUB(
                                        f.fecfin,
                                        INTERVAL (MINUTE(f.fecfin) % 15) MINUTE
                                    ),
                                    INTERVAL 
                                        CASE 
                                            WHEN MINUTE(f.fecfin) % 15 >= 8 THEN 15
                                            ELSE 0
                                        END MINUTE
                                ),
                                INTERVAL 1 HOUR
                            ),
                            '%Y-%m-%d %H:%i:00'
                        ) AS start_calendar
                    ")
                )
                ->where('e.id', $idestudiante)
                ->where('s.id', $idsemester)
                ->orderBy('f.fecinicio')
                ->get();

            // 3) RESPUESTA: DataTables + foros anexos (igual que en list_horario_docente)
            return DataTables::of($data)
                ->addIndexColumn()
                ->with('foros', $foros)
                ->make(true);
        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los archivos'
        ]);
    }
}
