<?php

namespace App\Http\Controllers\alumno;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use App\Models\Forum;
use App\Models\Forumanswer;

class ForumController extends Controller
{
    public function index()
    {
        return view('alumno.foros.index');
    }

    public function list(Request $request, $idsubject)
    {
        if ($request->ajax()) {
            $idUsuario = Auth::User()->id;

            DB::statement("SET lc_time_names = 'es_ES'");

            $data = DB::table('foros as f')
                ->select(
                    'f.id AS idforum',
                    'f.titulo AS titulo',
                    'f.descripcion AS descripcion',
                    'f.fecinicio AS fecinicio',
                    'f.fecfin AS fecfin',
                    DB::raw('DATE_FORMAT(f.fecinicio, "%W %e de %M del %Y") AS fecinicio2'),
                    DB::raw('DATE_FORMAT(f.fecfin, "%W %e de %M del %Y") AS fecfin2'),
                    DB::raw('DATE_FORMAT(f.updated_at, "%W %e de %M del %Y") AS fecha_mod'),
                    DB::raw('CONCAT(u.nombres, " ", u.apellido_pa, " ", u.apellido_ma) AS autor')
                )
                ->join('asignaturas as a', 'a.id', '=', 'f.subject_id')
                ->join('matriculas_asignaturas AS ma', 'ma.subject_id', '=', 'a.id')
                ->join('estudiantes AS es', 'es.id', '=', 'ma.student_id')
                ->join('usuarios as u', 'u.id', '=', 'es.user_id')
                ->where('a.id', $idsubject)
                ->where('es.user_id', $idUsuario)
                ->orderBy('f.fecinicio')
                ->get();

            return response()->json($data);
        }
        return  response()->json(["status" => false, "mensaje" => 'Error en request']);
    }

    public function list_forum_answers(Request $request, $idforum)
    {
        if ($request->ajax()) {
            DB::statement("SET lc_time_names = 'es_ES'");
            $data = DB::table('respuestas_foros as rf')
                ->select(
                    'rf.id AS idforumanswer',
                    'rf.comentario AS comentario',
                    'rf.updated_at AS fecha_mod',
                    DB::raw('DATEDIFF(now(), rf.updated_at) AS dias_transcurridos'),
                    'e.id AS idstudent',
                    'u.id AS iduser',
                    DB::raw('CONCAT(u.nombres, " ", u.apellido_pa, " ", u.apellido_ma) AS estudiante')
                )
                ->join('foros as f', 'f.id', '=', 'rf.forum_id')
                ->join('estudiantes as e', 'e.id', '=', 'rf.student_id')
                ->join('usuarios as u', 'u.id', '=', 'e.user_id')
                ->where('rf.forum_id', $idforum)
                ->get();

            return response()->json($data);
        }
        return  response()->json(["status" => false, "mensaje" => 'Error en request']);
    }

    public function store(Request $request)
    {
        $user = Auth::user();
        $studentdata = $user->students;
        $idstudent = $studentdata[0]->id;

        $item = new Forumanswer();
        $item->student_id = $idstudent;
        $item->forum_id = $request->input('dt-idforum');
        $item->comentario = $request->input('dt-comentario');

        if ($item->save()) {
            return response()->json(["status" => true, "mensaje" => 'Evaluación registrada']);
        } else {
            // El guardado falló
            return response()->json(["status" => false, "mensaje" => 'Error: No se registro la evaluación']);
        }
    }


    public function update(Request $request, $idforumanswer)
    {
        $item = Forumanswer::find($idforumanswer);
        $item->comentario = $request->input('dt-comentario');

        if ($item->save()) {
            return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
        }
    }


    public function destroy($id)
    {
        // Busca el registro por su ID
        $item = Forum::find($id);

        // Verifica si el registro existe
        if (!$item) {
            return response()->json(["status" => false, "mensaje" => 'El registro no existe']);
        }

        // Elimina el registro de la base de datos
        if ($item->delete()) {
            return response()->json(["status" => true, "mensaje" => 'El registro fue eliminado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'El registro no fue eliminado']);
        }
    }
}
