<?php

namespace App\Http\Controllers\alumno;

use App\Http\Controllers\Controller;
use App\Models\Tddocument;
use App\Models\Tdmovement;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use Yajra\DataTables\DataTables;

class AlumnoTraminteDocumentarioController extends Controller
{

    public function index(Request $request)
    {
        return view('alumno.tramitedocumentario.index');
    }

    public function list(Request $request)
    {
        if ($request->ajax()) {

            $results = Tdmovement::select(
                'tdd.id as iddocumento',
                'td_movimientos.id as idmovimiento',
                'u.nombres',
                'tdd.codigosolicitud',
                'u.nroidenti',
                'u.correo',
                'u.celular',
                'tdd.asunto',
                'td_archivos.nombre AS nombredoc',
                'td_archivos.ruta_archivo',
                'tdd.created_at',
                'tdd.folio',
                'td_movimientos.estado',
                'td_comprobantes.comprobante',
                'td_movimientos.areaorigen',
                'td_movimientos.areadestino',
                'td_archivos.nombre AS namedocemitido',
                DB::raw('ROW_NUMBER() OVER (PARTITION BY tdd.student_id, td_comprobantes.comprobante, td_comprobantes.concepto ORDER BY tdd.created_at DESC, td_movimientos.id DESC) AS rn')
                )
            ->join('td_documentos as tdd', 'td_movimientos.tddocument_id', '=', 'tdd.id')
            ->join('td_archivos', 'tdd.id', '=', 'td_archivos.tddocument_id')
            ->join('td_comprobantes', 'tdd.id', '=', 'td_comprobantes.tddocument_id')
            ->join('estudiantes as e','tdd.student_id', '=',  'e.id' )
            ->join('usuarios as u','e.user_id', '=','u.id' )
            ->get();


            // Filtrar por rn = 1
            $results2 = $results->where('rn', 1);
            $results3 = $results2->where('nroidenti', Auth::User()->nroidenti);
            $results4 = $results3->whereIn('estado', ['1', '2']);
            $data = $results4->values();

            return DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }

        return response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los archivos',
        ]);
    }

    // public function listadmotherfinalizado(Request $request)
    // {
    //     if ($request->ajax()) {

    //         $nroidenti = Auth::User()->nroidenti;

    //         $results = Tddocument::select(
    //             'td_documentos.id as iddocumento',
    //             'td_movimientos.id as idmovimiento',
    //             'td_documentos.NOMBRES',
    //             'td_documentos.DNI',
    //             'td_documentos.EMAIL',
    //             'td_documentos.CELULAR',
    //             'td_documentos.ASUNTO',
    //             'td_archivos.NOMBRE AS NOMBREDOC',
    //             'td_archivos.RUTA_ARCHIVO',
    //             'td_documentos.FECHA_DOCUMENTO',
    //             'td_documentos.FOLIO',
    //             'td_movimientos.ESTADO',
    //             'td_comprobantes.COMPROBANTE',
    //             'td_movimientos.AREAORIGEN',
    //             'td_movimientos.AREADESTINO',
    //             'td_movimientos_archivos.NOMBRE AS NAMEDOCEMITIDO',
    //             DB::raw('ROW_NUMBER() OVER (PARTITION BY td_documentos.DNI, td_comprobantes.COMPROBANTE ORDER BY td_documentos.FECHA_DOCUMENTO DESC, td_movimientos.id DESC) AS rn')
    //         )
    //             ->join('td_archivos', 'td_documentos.id', '=', 'td_archivos.IDDOCUMENTO')
    //             ->join('td_comprobantes', 'td_documentos.id', '=', 'td_comprobantes.IDDOCUMENTO')
    //             ->join('td_movimientos', 'td_documentos.id', '=', 'td_movimientos.IDDOCUMENTO')
    //             ->join('td_movimientos_archivos', 'td_movimientos.id', '=', 'td_movimientos_archivos.IDMOVIMIENTO')
    //             ->orderBy('td_documentos.DNI')
    //             ->orderBy('td_comprobantes.COMPROBANTE')
    //             ->orderByDesc('td_documentos.FECHA_DOCUMENTO')
    //             ->orderByDesc('td_movimientos.id')
    //             ->orderBy('td_movimientos.ESTADO', 'ASC') // Ordenar por estado en ascendente
    //             ->get();

    //         // Filtrar por rn = 1
    //                // Filtrar por rn = 1
    //                $results2 = $results->where('rn', 1);
    //                $results3 = $results2->where('DNI',$nroidenti );
    //                $results4 = $results3->where('ESTADO',"2" );
    //                $data = $results3->values();

    //         return DataTables::of($data)
    //             ->addIndexColumn()
    //             ->make(true);
    //     }

    //     return response()->json([
    //         "status" => false,
    //         "mensaje" => 'Error: no se pueden cargar los archivos',
    //     ]);
    // }


    public function listfinalizados(Request $request)
    {
        if ($request->ajax()) {

            $results = Tdmovement::select(
                'tdd.id as iddocumento',
                'td_movimientos.id as idmovimiento',
                'u.nombres',
                'tdd.codigosolicitud',
                'u.nroidenti',
                'u.correo',
                'u.celular',
                'tdd.asunto',
                'td_archivos.nombre AS nombredoc',
                'td_archivos.ruta_archivo',
                'tdd.created_at',
                'tdd.folio',
                'td_movimientos.estado',
                'td_comprobantes.comprobante',
                'td_movimientos.areaorigen',
                'td_movimientos.areadestino',
                'td_movimientos_archivos.nombre AS namedocemitido',
                DB::raw('ROW_NUMBER() OVER (PARTITION BY tdd.student_id, td_comprobantes.comprobante, td_comprobantes.concepto ORDER BY tdd.created_at DESC, td_movimientos.id DESC) AS rn')
                )
            ->join('td_documentos as tdd', 'td_movimientos.tddocument_id', '=', 'tdd.id')
            ->join('td_archivos', 'tdd.id', '=', 'td_archivos.tddocument_id')
            ->join('td_comprobantes', 'tdd.id', '=', 'td_comprobantes.tddocument_id')
            ->join('td_movimientos_archivos', 'td_movimientos.id', '=', 'td_movimientos_archivos.tdmovement_id')
            ->join('estudiantes as e','tdd.student_id', '=',  'e.id' )
            ->join('usuarios as u','e.user_id', '=','u.id' )
            ->get();

                // Filtrar por rn = 1
                $results2 = $results->where('rn', 1);
                $results3 = $results2->where('nroidenti', Auth::User()->nroidenti);
                $results4 = $results3->where('estado',"3" );
                $data = $results4->values();

            return DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }

        return response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los archivos',
        ]);
    }


    public function viewDocumentoSolicitante($dni, $operacion, $codigosolicitud, $nombredoc)
    {

        $nroidenti = Auth::User()->nroidenti;

        $ruta = 'public/Repotramitesdocumentarios/'.$nroidenti.'/'.$operacion.'/'.$codigosolicitud.'/'.$nombredoc;
        $file = storage_path('app/' . $ruta);

        if (file_exists($file)) {
            $headers = [
                'Content-Type' => 'application/pdf'
            ];
            $cadenaAleatoria = Str::random(20);
            $fileTitle = 'Nro_OP_' . $operacion .'_'. $cadenaAleatoria . '_DOC_' . $nombredoc . '.pdf';

            return response()->download($file, $fileTitle, $headers, 'inline');
        } else {
            return response()->json(['error' => 'Archivo del solictante no encontrado'], 404);
        }
    }


    public function viewDocumentoEmitido($dni, $operacion, $codigosolicitud, $nombredoc)
    {

        $nroidenti = Auth::User()->nroidenti;

        $ruta = 'public/Repotramitesdocumentarios/'.$nroidenti.'/'.$operacion.'/'.$codigosolicitud.'/'.$nombredoc;
        $file = storage_path('app/' . $ruta);

        if (file_exists($file)) {
            $headers = [
                'Content-Type' => 'application/pdf'
            ];
            $cadenaAleatoria = Str::random(20);
            $fileTitle = 'Nro_OP_' . $operacion .'_'. $cadenaAleatoria . '_DOC_' . $nombredoc . '.pdf';

            return response()->download($file, $fileTitle, $headers, 'inline');
        } else {
            return response()->json(['error' => 'Archivo del solictante no encontrado'], 404);
        }
    }

}
