<?php

namespace App\Http\Controllers\alumno;

use App\Http\Controllers\Controller;

use App\Http\Controllers\sidebar\SidebarController;
use App\Models\Pago;
use App\Models\PagoMatricula;
use App\Models\Semesterenrollment;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;
use Barryvdh\DomPDF\Facade\Pdf as PDF;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Providers\AppServiceProvider;

class AlumnoPagoController extends Controller
{
    //
    public function index(Request $request)
    {
        return view('alumno.pagos.index');
    }


    //
    public function list(Request $request)
    {
        if ($request->ajax()) {

            $user = Auth::user();
            $studentdata = $user->students;
            $idstudent = $studentdata[0]->id;

            $idconcepto = $request->input('idconcepto');
            $estado_pago = $request->input('estado_pago');

            $data = DB::table('pagos as pa')
                ->select(
                    'pa.id as idpago',
                    DB::raw('DATE_FORMAT(pa.fecha, "%d/%m/%Y") as fecha2'),
                    'pa.fecha',
                    'pa.documento',
                    'pa.nro_operacion',
                    'pa.monto_inicial',
                    'pa.descuento',
                    'pa.monto_final',
                    'pa.estado',
                    'se.id as idsemester',
                    DB::raw('COALESCE(CONCAT(se.anho, "-", se.numero), "") as semestre'),
                    'es.id as idest',
                    'uses.id as idusuario_est',
                    'tiid_est.tipo as tipoidenti_est',
                    'uses.nroidenti as nroidenti_est',
                    'uses.nombres as nombres_est',
                    'uses.apellido_pa as apellido_pa_est',
                    'uses.apellido_ma as apellido_ma_est',
                    DB::raw('CONCAT(uses.nombres, " ",uses.apellido_pa , " ",uses.apellido_ma) as estudiante'),
                    'uses.telefono as telefono_est',
                    'uses.celular as celular_est',
                    'uses.correo as correo_est',
                    'ad.id as idadmin',
                    'usad.id as idusuario_adm',
                    'tiid_adm.tipo as tipoidenti_adm',
                    DB::raw('COALESCE(usad.nroidenti, "") as nroidenti_adm'),
                    DB::raw('COALESCE(usad.nombres, "") as nombres_adm'),
                    DB::raw('COALESCE(usad.apellido_pa, "") as apellido_pa_adm'),
                    DB::raw('COALESCE(usad.apellido_ma, "") as apellido_ma_adm'),
                    DB::raw('COALESCE(usad.telefono, "") as telefono_adm'),
                    DB::raw('COALESCE(usad.celular, "") as celular_adm'),
                    DB::raw('COALESCE(usad.correo, "") as correo_adm'),
                    'co.id as idconcepto',
                    'co.nombre as nombreconcepto',
                    'mepa.id as idmetodopago',
                    'mepa.nombre as nombremetodopago',
                    'ba.id as idbanco',
                    'ba.nombre as nombrebanco'
                )
                ->join('estudiantes as es', 'pa.student_id', '=', 'es.id')
                ->join('usuarios as uses', 'es.user_id', '=', 'uses.id')
                ->join('tipos_identificaciones as tiid_est', 'uses.identificationtype_id', '=', 'tiid_est.id')
                ->leftJoin('administradores as ad', 'pa.administrator_id', '=', 'ad.id')
                ->leftJoin('usuarios as usad', 'ad.user_id', '=', 'usad.id')
                ->leftJoin('tipos_identificaciones as tiid_adm', 'usad.identificationtype_id', '=', 'tiid_adm.id')
                ->leftJoin('conceptos as co', 'pa.concepto_id', '=', 'co.id')
                ->leftJoin('metodos_pagos as mepa', 'pa.metodo_pago_id', '=', 'mepa.id')
                ->leftJoin('bancos as ba', 'pa.banco_id', '=', 'ba.id')
                ->leftJoin('semestres as se', 'pa.semester_id', '=', 'se.id')
                ->orderBy('pa.fecha','desc')
                ->where('es.id', $idstudent);

                if($idconcepto != "all") {
                    $data = $data->where('co.id', $idconcepto);
                }

                if($estado_pago != "all") {
                    $data = $data->where('pa.estado', $estado_pago);
                }

                $data = $data->get();

            return \Yajra\DataTables\DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los archivos'
        ]);
    }


    public function update(Request $request)
    {
        // validar documento
        $validator = Validator::make($request->all(), [
            'txt-documento' => 'mimes:pdf,jpg,png|max:2000', // Valida PDF y tamaño máximo de 2MB
        ], [
            'txt-documento.mimes' => 'El archivo debe ser un PDF.',
            'txt-documento.max' => 'El tamaño del archivo no debe superar los 2000 KB.',
        ]);
        // documento inválido
        if ($validator->fails()) {
            return response()->json([
                "status" => 'validators', "mensaje" => $validator->errors(),
            ]);
        } else {
            // nuevo Pago
            $item = Pago::find($request->input('txt-idpago'));
            $item->concepto_id = $request->input('txt-concepto_id');
            $item->metodo_pago_id = $request->input('txt-metodo_pago_id');
            $item->banco_id = $request->input('txt-banco_id');
            $item->estado = 2;
            $item->nro_operacion = $request->input('txt-nro_operacion');
            $item->documento = '--';

            $idpago = $request->input('txt-idpago');

            // guardar documento si existe
            if ($request->hasFile('txt-documento')) {
                $folderName =  'public/students/' . $request->input('txt-student_id') . '/' . 'pagos/' . $idpago;
                Storage::disk('local')->makeDirectory($folderName);   // creamos la carpeta en el disco local
                $archivo = $request->file('txt-documento');   // obtenemos el archivo
                $archivo->storeAs($folderName, 'voucher.pdf');  // guardado (ruta,nombre del archivo)
                $filePath = $folderName . '/' . 'voucher.pdf';  // ruta del archivo
                $item->documento = $filePath;
                // guardar Pago - documento
                if ($item->save()) {
                    return response()->json(["status" => true, "mensaje" => 'Pago actualizado']);
                }
            }

            // guardar
            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Pago actualizado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Pago no actualizado']);
            }
        }
    }


    public function verPagoDocumento($idpago)
    {
        $item = Pago::find($idpago);

        $item->documento;

        $file = storage_path('app/') . $item->documento;
        if (file_exists($file)) {
            $headers = [
                'Content-Type' => 'application/pdf'
            ];
            // $fileTitle = '' . $tipoidenti . '_' . $nroidenti . ' - TIPO_' . $nombre . '.pdf';
            $fileTitle = '.pdf';
            return response()->download($file, $fileTitle, $headers, 'inline');
        } else {
            abort(404, 'Archivo no encontrado!');
        }
    }


    public function ajax_all(Request $request)
    {
        if ($request->ajax()) {

            $data = Pago::all();

            return response()->json($data);
        }
        return  response()->json(["status" => false, "mensaje" => 'Error en request']);
    }

    public function boleta_pago($idpago)
    {
        $infos = DB::table('pagos as pa')
        ->select(
            'pa.id as idpago',
            'pa.fecha',
            'pa.documento',
            'pa.nro_operacion',
            'pa.monto_inicial',
            'pa.descuento',
            'pa.monto_final',
            'pa.estado',
            'es.id as idest',
            'uses.id as idusuario_est',
            'tiid_est.tipo as tipoidenti_est',
            'uses.nroidenti as nroidenti_est',
            'uses.nombres as nombres_est',
            'uses.apellido_pa as apellido_pa_est',
            'uses.apellido_ma as apellido_ma_est',
            DB::raw('CONCAT(uses.apellido_pa, " ", uses.apellido_ma, ", ", uses.nombres) as estudiante'),
            'uses.telefono as telefono_est',
            'uses.celular as celular_est',
            'uses.correo as correo_est',
            'ad.id as idadmin',
            'usad.id as idusuario_adm',
            DB::raw('CONCAT(tiid_est.tipo, " - ", uses.nroidenti) AS identificacion'),
            'tiid_adm.tipo as tipoidenti_adm',
            'usad.nroidenti as nroidenti_adm',
            'usad.nombres as nombres_adm',
            'usad.apellido_pa as apellido_pa_adm',
            'usad.apellido_ma as apellido_ma_adm',
            'usad.telefono as telefono_adm',
            'usad.celular as celular_adm',
            'usad.correo as correo_adm',
            'co.id as idconcepto',
            'co.nombre as nombreconcepto',
            'mepa.id as idmetodopago',
            'mepa.nombre as nombremetodopago',
            'ba.id as idbanco',
            'ba.nombre as nombrebanco'
        )
        ->join('estudiantes as es', 'pa.student_id', '=', 'es.id')
        ->join('usuarios as uses', 'es.user_id', '=', 'uses.id')
        ->join('tipos_identificaciones as tiid_est', 'uses.identificationtype_id', '=', 'tiid_est.id')
        ->join('administradores as ad', 'pa.administrator_id', '=', 'ad.id')
        ->join('usuarios as usad', 'ad.user_id', '=', 'usad.id')
        ->join('tipos_identificaciones as tiid_adm', 'usad.identificationtype_id', '=', 'tiid_adm.id')
        ->join('conceptos as co', 'pa.concepto_id', '=', 'co.id')
        ->leftJoin('metodos_pagos as mepa', 'pa.metodo_pago_id', '=', 'mepa.id')
        ->leftJoin('bancos as ba', 'pa.banco_id', '=', 'ba.id')
        ->where('pa.id','=',$idpago)
        ->where('pa.estado','=', 1)
        ->get();


        $pdf = PDF::loadView('reportes.boleta_pago', [
            'institutions' => AppServiceProvider::$institutions,
            'infos' => $infos
        ]);

        // Define el tamaño del papel como boleta (ancho: 8 cm, alto: 21 cm)
        $pdf->setPaper([0, 0, 226.77, 566.93], 'portrait');

        return $pdf->stream();
    }
}
