<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\sidebar\SidebarController;
use App\Models\Role;
use App\Models\Ubigeo;
use App\Models\User;
use App\Models\Usertype;
use App\Services\Moodle\MoodleRoleService;
use App\Services\Moodle\MoodleUserService;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;
use Yajra\DataTables\Facades\DataTables;
use Illuminate\Support\Facades\Storage;
use PhpOffice\PhpSpreadsheet\IOFactory;

class UserController extends Controller
{

    public function index(Request $request)
    {
        return view('admin.seguridad.usuarios.index');
    }

    public function list(Request $request)
    {
        if ($request->ajax()) {
            // query
            $data = User::join('tipos_identificaciones AS it', 'it.id', '=', 'usuarios.identificationtype_id')
                ->leftJoin('tipos_usuarios AS ut', 'ut.id', '=', 'usuarios.usertype_id')
                ->join('ubigeos AS ub', 'ub.id', '=', 'usuarios.ubigeo_id')
                ->join('generos AS g', 'g.id', '=', 'usuarios.genre_id')
                ->orderBy('usuarios.apellido_pa', 'asc')
                ->orderBy('usuarios.apellido_ma', 'asc')
                ->orderBy('usuarios.nombres', 'asc')
                ->get([
                    'usuarios.id AS iduser',
                    'usuarios.nroidenti',
                    'usuarios.password',
                    'usuarios.nombres',
                    'usuarios.apellido_pa',
                    'usuarios.apellido_ma',
                    DB::raw('CONCAT(usuarios.apellido_pa, " ", usuarios.apellido_ma) AS apellidos'),
                    'usuarios.fecnac',
                    'usuarios.correo',
                    'usuarios.telefono',
                    'usuarios.celular',
                    'usuarios.direccion',
                    'usuarios.estado',
                    'it.id AS ididentificationtype',
                    'it.tipo AS tipoidenti',
                    'ut.id AS idusertype',
                    DB::raw('IFNULL(ut.tipo, "Ninguno") AS tipo_usuario'),
                    'ub.id AS idubigeo',
                    DB::raw('SUBSTRING(ub.id, 1, 2) AS iddepartamento'),
                    'ub.departamento',
                    DB::raw('SUBSTRING(ub.id, 3, 2) AS idprovincia'),
                    'ub.provincia',
                    DB::raw('SUBSTRING(ub.id, 5, 2) AS iddistrito'),
                    'ub.distrito',
                    'g.id AS idgenre',
                    'g.nombre AS nombregenre'
                ]);
            // datatable
            return DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }

        return  response()->json(["status" => false, "mensaje" => 'Error: no se pueden cargar los archivos']);
    }

    public function store(Request $request)
    {
        function capitalizarArray($array)
        {
            return array_map(function ($elemento) {
                return ucwords(strtolower($elemento));
            }, $array);
        }

        $r_nroidenti = $request->input('txt_nroidenti');

        $usuario = User::where('nroidenti', $r_nroidenti)->first();

        if ($usuario) {
            return response()->json(["status" => false, "mensaje" => 'El usuario ya está registrado']);;
        }

        // SI NO EXISTE EL USUARIO CON EL NUMERO DE IDENTIFICACION
        else {
            // SI EL USUARIO NO EXISTE

            // nuevo objeto
            $item = new User();
            // setear datos
            $item->identificationtype_id = $request->input('txt-identificationtype');
            $item->nroidenti = $request->input('txt_nroidenti');
            $item->password = $request->input('txt_password');
            $item->estado = $request->input('txt_estado');
            $item->nombres = ucwords(strtolower($request->input('txt_nombres')));
            $item->apellido_pa = ucwords(strtolower($request->input('txt_apellido_pa')));
            $item->apellido_ma = ucwords(strtolower($request->input('txt_apellido_ma')));
            $item->fecnac = $request->input('txt_fecnac');
            $item->correo = $request->input('txt_correo');
            $item->telefono = $request->input('txt_telefono');
            $item->celular = $request->input('txt_celular');
            $item->genre_id = $request->input('txt_genre_id');
            $idubigeo = $request->input('txt_departamento') . $request->input('txt_provincia') . $request->input('txt_distrito');
            $item->ubigeo_id = $idubigeo;
            $item->direccion = $request->input('txt_direccion');
            $item->usertype_id = NULL;

            // validar guardado
            if ($item->save()) {

                // // MOODLE USER SERVICE
                // $moodleUserService = new MoodleUserService();
                // $mdlUsername = $item->nroidenti;
                // // $mdlPassword = $item->password;
                // $mdlPassword = "{$item->nroidenti}PE";
                // $mdlFirstname = $item->nombres;
                // $mdlLastname = "$item->apellido_pa $item->apellido_ma";
                // $mdlEmail = $item->correo;
                // $resultmdlUser = $moodleUserService->create($mdlUsername, $mdlPassword, $mdlFirstname, $mdlLastname, $mdlEmail);
                // // Guardar Id de Moodle
                // if (isset($resultmdlUser[0]['id'])) {
                //     $item->moodle_id = $resultmdlUser[0]['id'];
                //     $item->save();
                // }
                // // MOODLE USER SERVICE

                return response()->json(["status" => true, "mensaje" => 'Usuario insertado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Usuario no insertado']);
            }
        }
    }

    public function update_password(Request $request, $id)
    {

        $item = User::find($id);

        // validar existencia del registro
        if (!$item) {
            abort(404);
        } else {
            // recoger datos
            $item->password = $request->input('txt_password2');
            // validar guardado
            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
            }
        }
    }

    public function destroy($id)
    {
        // Busca el registro por su ID
        $usuario = User::find($id);
        if (!$usuario) {
            return response()->json(["status" => false, "mensaje" => 'El registro no existe']);
        }

        $idusertype = $usuario->usertype_id;

        // // MOODLE ROLE SERVICE
        // $moodleRoleService = new MoodleRoleService();
        // $moodleRoleService->unassignAdminRoleFromUser($usuario->moodle_id);
        // // MOODLE ROLE SERVICE

        // SI SOLO ES USUARIO
        if ($idusertype == NULL) {
            // validar eliminación
            if ($usuario->delete()) {
                return response()->json(["status" => true, "mensaje" => 'El usuario fue eliminado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'El usuario no fue eliminado']);
            }
        }
        // SI TIENEN ROLES
        $userType = Usertype::find($idusertype);
        if (!$userType) {
            return response()->json(["status" => false, "mensaje" => 'El tipo de usuario no existe']);
        } else {
            $nombreTipoUsuario = $userType->tipo;
            return response()->json(["status" => false, "mensaje" => "El usuario no fue eliminado por ser $nombreTipoUsuario"]);
        }
    }


    public function update(Request $request, $id)
    {

        $item = User::find($id);

        // validar existencia del registro
        if (!$item) {
            abort(404);
        } else {
            // recoger datos
            $item->identificationtype_id = $request->input('txt-identificationtype');
            $item->nroidenti = $request->input('txt_nroidenti');
            $item->estado = $request->input('txt_estado');
            $item->genre_id = $request->input('txt_genre_id');
            $item->nombres = ucwords(strtolower($request->input('txt_nombres')));
            $item->apellido_pa = ucwords(strtolower($request->input('txt_apellido_pa')));
            $item->apellido_ma = ucwords(strtolower($request->input('txt_apellido_ma')));
            $item->fecnac = $request->input('txt_fecnac');
            $item->correo = $request->input('txt_correo');
            $item->telefono = $request->input('txt_telefono');
            $item->celular = $request->input('txt_celular');
            $item->direccion = $request->input('txt_direccion');
            $idubigeo = $request->input('txt_departamento') . $request->input('txt_provincia') . $request->input('txt_distrito');
            $item->ubigeo_id = $idubigeo;
            // validar guardado
            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Usuario actualizado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Usuario no actualizado']);
            }
        }
    }

    public function ajax_all_by_nroidenti(Request $request, $nroidenti)
    {
        if ($request->ajax()) {
            $data = User::where('nroidenti', $nroidenti)->get();
            return response()->json($data);
        }
        return  response()->json(["status" => false, "mensaje" => 'Error en request']);
    }

    public function query_bd($nroidenti)
    {
        $response = User::join('tipos_identificaciones AS it', 'it.id', '=', 'usuarios.identificationtype_id')
            ->join('tipos_usuarios AS ut', 'ut.id', '=', 'usuarios.usertype_id')
            ->join('ubigeos AS ub', 'ub.id', '=', 'usuarios.ubigeo_id')
            ->join('generos AS g', 'g.id', '=', 'usuarios.genre_id')
            ->orderBy('usuarios.apellido_pa', 'asc')
            ->orderBy('usuarios.apellido_ma', 'asc')
            ->orderBy('usuarios.nombres', 'asc')
            ->get([
                'usuarios.id AS iduser',
                'usuarios.nroidenti',
                'usuarios.password',
                'usuarios.nombres',
                'usuarios.apellido_pa',
                'usuarios.apellido_ma',
                DB::raw('CONCAT(usuarios.apellido_pa, " ", usuarios.apellido_ma) AS apellidos'),
                'usuarios.fecnac',
                'usuarios.correo',
                'usuarios.telefono',
                'usuarios.celular',
                'usuarios.direccion',
                'usuarios.estado',
                'it.id AS ididentificationtype',
                'it.tipo AS tipoidenti',
                'ut.id AS idusertype',
                'ut.tipo',
                'ub.id AS idubigeo',
                DB::raw('SUBSTRING(ub.id, 1, 2) AS iddepartamento'),
                'ub.departamento',
                DB::raw('SUBSTRING(ub.id, 3, 2) AS idprovincia'),
                'ub.provincia',
                DB::raw('SUBSTRING(ub.id, 5, 2) AS iddistrito'),
                'ub.distrito',
                'g.id AS idgenre',
                'g.nombre AS nombregenre'
            ])->where('nroidenti', $nroidenti);

        return response()->json([
            "status" => true,
            "mensaje" => 'Consulta realizada',
            "data" => $response
        ]);
    }

    public function ajax_all_doc_adm(Request $request)
    {
        if ($request->ajax()) {
            // $data = Teacher::all();
            $data = DB::table('usuarios as u')
                ->join('tipos_identificaciones AS it', 'it.id', '=', 'u.identificationtype_id')
                ->select(
                    'u.id as iduser',
                    'it.id AS ididentificationtype',
                    'it.tipo AS tipoidenti',
                    'u.nroidenti',
                    'u.nombres',
                    'u.apellido_pa',
                    'u.apellido_ma',
                    'u.fecnac',
                    'u.correo',
                    'u.telefono',
                    'u.celular',
                    'u.direccion',
                    'u.estado'
                )
                ->orderBy('u.apellido_pa', 'asc')
                ->orderBy('u.apellido_ma', 'asc')
                ->orderBy('u.nombres', 'asc')
                ->where('u.usertype_id', '!=', '3')
                ->get();
            return response()->json($data);
        }
        return  response()->json(["status" => false, "mensaje" => 'Error en request']);
    }

    public function ajax_all(Request $request)
    {
        if ($request->ajax()) {
            // $data = Teacher::all();
            $data = DB::table('usuarios as u')
                ->join('tipos_identificaciones AS it', 'it.id', '=', 'u.identificationtype_id')
                ->select(
                    'u.id as iduser',
                    'it.id AS ididentificationtype',
                    'it.tipo AS tipoidenti',
                    'u.nroidenti',
                    'u.nombres',
                    'u.apellido_pa',
                    'u.apellido_ma',
                    'u.fecnac',
                    'u.correo',
                    'u.telefono',
                    'u.celular',
                    'u.direccion',
                    'u.estado'
                )
                ->orderBy('u.apellido_pa', 'asc')
                ->orderBy('u.apellido_ma', 'asc')
                ->orderBy('u.nombres', 'asc')
                ->get();
            return response()->json($data);
        }
        return  response()->json(["status" => false, "mensaje" => 'Error en request']);
    }

    public function downloadExcelFile(Request $request)
    {
        $fileName = 'public/Plantillainscripciones/Plantilla_usuarios.xlsx';

        // Verificar si el archivo existe
        if (Storage::disk('local')->exists($fileName)) {
            // Obtener el archivo del storage

            $file = storage_path('app/' . $fileName);
            $plantilla = IOFactory::load($file);

            // Establecer encabezados para forzar la descarga
            header("Content-Disposition: attachment; filename=" . $file);
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header('Cache-Control: max-age=0');

            $writer = IOFactory::createWriter($plantilla, 'Xlsx');
            $writer->save('php://output');
        } else {
            // Mostrar un error
            return abort(404);
        }
    }


    public function store_plantilla(Request $request)
    {
        $columnas = $request->input('datajsondos');
        $countUsers = 0;
        $countrepetido = 0;
        $miArraynroidentiRepet = [];

        foreach ($columnas as $columna) {

            // Verifica si el número de documento ya está registrado
            $existeDni = User::where('nroidenti', $columna[1])->exists();
            if ($existeDni) {
                return response()->json([
                    "status" => false,
                    "mensaje" => 'Hay números de identificación en la plantilla ya registrados'
                ]);
            }

            // Verifica si el correo ya está registrado
            $existeCorreo = User::where('correo', $columna[6])->exists();
            if ($existeCorreo) {
                return response()->json([
                    "status" => false,
                    "mensaje" => 'Hay correos en la plantilla ya registrados'
                ]);
            }

            // Verifica si el ubigeo ya está registrado
            $existeUbigeo = Ubigeo::where('id', $columna[10])->exists();
            if (!$existeUbigeo) {
                return response()->json([
                    "status" => false,
                    "mensaje" => 'Hay ubigeos que no existen en el sistema'
                ]);
            }
        }

        foreach ($columnas as $columna) {

            $user = User::where('nroidenti', $columna[1])->first();

            if ($user) {
                $countrepetido++;
                array_push($miArraynroidentiRepet, $columna[1]);
            } else {
                $item = new User();

                // TIPO IDENTI
                if ($columna[0] === 'DNI') {
                    $idtype = 1;
                } else if ($columna[0] === 'Carnét de Extranjería') {
                    $idtype = 2;
                }
                $item->identificationtype_id = $idtype;
                $item->nroidenti = $columna[1];
                $item->password = $columna[2];
                $item->nombres = $columna[3];
                $item->apellido_pa = $columna[4];
                $item->apellido_ma = $columna[5];
                $item->correo = $columna[6];
                $item->fecnac = Carbon::createFromDate(1900, 1, 1)->addDays($columna[7] - 2)->toDateString(); // Ajuste para fecha en Excel
                $item->telefono = $columna[8];
                $item->celular = $columna[9];
                $item->ubigeo_id = $columna[10];
                $item->direccion = $columna[11];
                $item->estado = "1";

                // GENERO
                if ($columna[12] === 'Masculino') {
                    $idgenre = '1';
                } else if ($columna[12] === 'Femenino') {
                    $idgenre = '2';
                } else if ($columna[12] === 'Otros') {
                    $idgenre = '3';
                }
                $item->genre_id = $idgenre;
                $item->usertype_id = NULL;

                // validar guardado
                if ($item->save()) {
                    $countUsers++;
                }
            }
        }

        if ($countUsers == count($columnas)) {
            $result = ["status" => true, "mensaje" => 'Registros insertados correctamente'];
        } else if (($countUsers > 1 && $countrepetido > 1)) {
            $result = ["status" => true, "mensaje" => 'Registros Insertados: ' . $countUsers . ' Registros no insertados: ' . $countrepetido, "Repet" => $miArraynroidentiRepet];
        } else {
            $result = ["status" => false, "mensaje" => 'Error al insertar plantilla'];
        }
        return response()->json($result);
    }
}
