<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Models\TeacherRequirement;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class TeacherRequirementController extends Controller
{
    public function index()
    {
        return view('admin.institucion.requisitosdocente.index');
    }


    public function list(Request $request)
    {
        if ($request->ajax()) {
            $data = TeacherRequirement::get();

            return \Yajra\DataTables\DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }

        return  response()->json(["status" => false, "mensaje" => 'Error: no se pueden cargar los archivos']);
    }


    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'txt-nombre' => 'required|string|max:255'
        ]);

        if ($validator->fails()) {
            return response()->json(["status" => false, "mensaje" => $validator->errors()->first()]);
        }

        try {
            $item = new TeacherRequirement();
            $item->nombre = $request->input('txt-nombre');

            $item->save();

            return response()->json(["status" => true, "mensaje" => 'Registro insertado con éxito']);
        } catch (\Exception $e) {
            return response()->json(["status" => false, "mensaje" => 'Error al guardar el registro.']);
        }
    }


    public function update(Request $request, $id)
    {
        $item = TeacherRequirement::find($id);

        if (!$item) {
            return response()->json(["status" => false, "mensaje" => 'Registro no encontrado']);
        }

        $validator = Validator::make($request->all(), [
            'txt-nombre' => 'required|string|max:255'
        ]);

        if ($validator->fails()) {
            return response()->json(["status" => false, "mensaje" => $validator->errors()->first()]);
        }

        try {
            $item->nombre = $request->input('txt-nombre');

            $item->save();

            return response()->json(["status" => true, "mensaje" => 'Registro actualizado con éxito']);
        } catch (\Exception $e) {
            return response()->json(["status" => false, "mensaje" => 'Error al actualizar el registro.']);
        }
    }


    public function destroy($id)
    {
        $item = TeacherRequirement::find($id);

        if (!$item) {
            return response()->json(["status" => false, "mensaje" => 'El registro no existe']);
        }

        if ($item->delete()) {
            return response()->json(["status" => true, "mensaje" => 'El registro fue eliminado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'El registro no fue eliminado']);
        }
    }
}
