<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;

use App\Http\Controllers\sidebar\SidebarController;
use App\Models\Teacher;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Yajra\DataTables\Facades\DataTables;
use Illuminate\Support\Facades\Hash;

class TeacherProfileController extends Controller
{
    //
    // public function index()
    // {
    //     $objeto = new SidebarController();

    //     $sidebar = $objeto->ListmodulosSidebar();

    //     if (Auth::check()) {
    //         //si el usuario esta autentificado es admin le pasamos la lista del sidebar
    //         return view('docente.profile.index');
    //     } else {
    //         return redirect()->route('login')->withSuccess('Opps! You do not have access');
    //     }
    // }

    public function index(Request $request)
    {
        return view('docente.profile.index');
    }

    public function data(Request $request)
    {
        $user = Auth::user();
        $data = $user->docentes;
        $iddocente = $data[0]->id;

        if ($request->ajax()) {

            $data = DB::table('docentes AS te')
                ->join('usuarios AS us', 'us.id', '=', 'te.user_id')
                ->join('tipos_contratos_docentes AS tct', 'tct.id', '=', 'te.teachercontracttype_id')
                ->join('tipos_identificaciones AS it', 'it.id', '=', 'us.identificationtype_id')
                ->join('generos AS ge', 'ge.id', '=', 'us.genre_id')
                ->join('ubigeos AS ub', 'ub.id', '=', 'us.ubigeo_id')
                ->join('tipos_docentes AS tt', 'tt.id', '=', 'te.teachertype_id')
                ->select(
                    'tct.tipo AS tipocontrato',
                    'te.horas_lectivas',
                    'te.horas_nolectivas',
                    'te.estado',
                    'tt.nombre AS teachertype',
                    'tt.descripcion',
                    'us.id AS iduser',
                    'it.id AS ididentificationtype',
                    'it.tipo AS tipoidenti',
                    'us.nroidenti',
                    DB::raw("CONCAT(it.tipo, ' - ', us.nroidenti) as identificacion"),
                    DB::raw("CONCAT(us.apellido_pa, ' ', us.apellido_ma) AS user"),
                    'us.fecnac',
                    'us.correo',
                    'us.telefono',
                    'us.celular',
                    'us.direccion',
                    'us.ubigeo_id AS idubigeo',
                    'ge.id AS idgenero',
                    'ge.nombre AS genero',
                    'ub.id AS idubigeo',
                    DB::raw("SUBSTRING(ub.id, 1, 2) AS iddepartamento"),
                    'ub.departamento',
                    DB::raw("SUBSTRING(ub.id, 3, 2) AS idprovincia"),
                    'ub.provincia',
                    DB::raw("SUBSTRING(ub.id, 5, 2) AS iddistrito"),
                    'ub.distrito'
                )
            ->where('te.id', 1)
                ->get();


            return response()->json($data);
        }
        return  response()->json(["status" => false, "mensaje" => 'Error en request']);
    }


    public function update(Request $request)
    {
        $id = Auth::user()->id;

        $item = User::find($id);

        // validar existencia del registro
        if (!$item) {
            abort(404);
        } else {

            $item->genre_id = $request->input('txt_genero');
            $item->fecnac = $request->input('txt_fecnac');
            $item->correo = $request->input('txt_correo');
            $item->telefono = $request->input('txt_telefono');
            $item->celular = $request->input('txt_celular');
            $item->direccion = $request->input('txt_direccion');
            $idubigeo = $request->input('txt_departamento') . $request->input('txt_provincia') . $request->input('txt_distrito');
            $item->ubigeo_id = $idubigeo;
            // validar guardado
            if ($item->save()) {
                // El guardado fue exitoso
                return response()->json(["status" => true, "mensaje" => 'Datos actualizados']);
            } else {
                // El guardado falló
                return response()->json(["status" => false, "mensaje" => 'Datos no actualizados']);
            }
        }
    }

    public function update_password(Request $request)
    {
        $id = Auth::user()->id;
        $password = Auth::user()->password;
        $pass_actual = $request->input('txt_password1');
        $pass_nueva = $request->input('txt_password2');

        // if (Hash::check($pass_actual, $password)) {
        //     return response()->json([
        //         "status" => true,
        //         "mensaje" => "iguales"
        //     ]);
        // } else {
        //     return response()->json([
        //         "status" => false,
        //         "mensaje" => " no iguales"
        //     ]);
        // }

        if ( Hash::check($pass_actual, $password) ) {

            $item = User::find($id);

            // validar existencia del registro
            if (!$item) {
                abort(404);
            } else {
                // recoger datos
                $item->password = $request->input('txt_password2');
                // validar guardado
                if ($item->save()) {
                    return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
                } else {
                    return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
                }
            }

        } else {
            return response()->json([
                "status" => false,
                "errors" => ["Credenciales inválidas"]
            ]);
        }


    }
}
