<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;

use App\Http\Controllers\sidebar\SidebarController;
use App\Models\TdTipo;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Yajra\DataTables\Facades\DataTables;

class TdTipoController extends Controller
{


    public function index(Request $request)
    {
        return view('admin.institucion.td_tipos.index');
    }


    public function list(Request $request)
    {
        if ($request->ajax()) {

            $data = TdTipo::get();

            return \Yajra\DataTables\DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los archivos'
        ]);
    }


    public function store(Request $request)
    {

        $item = new TdTipo();
        $item->nombre = strtoupper($request->input('txt-nombre'));
        // Asigna otros campos según tus necesidades

        // Guarda el nuevo registro en la base de datos
        if ($item->save()) {
            return response()->json(["status" => true, "mensaje" => 'Registro insertado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'Registro no insertado']);
        }
    }


    public function update(Request $request, $id)
    {
        $item = TdTipo::find($id);

        if (!$item) {
            abort(404); // Manejo de error si no se encuentra el registro
        } else {
            $item->nombre = strtoupper($request->input('txt-nombre'));

            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
            }
        }
    }


    public function destroy($id)
    {
        // Busca el registro por su ID
        $item = TdTipo::find($id);

        // Verifica si el registro existe
        if (!$item) {
            return response()->json(["status" => false, "mensaje" => 'El registro no existe']);
        }

        // Elimina el registro de la base de datos
        if ($item->delete()) {
            return response()->json(["status" => true, "mensaje" => 'El registro fue eliminado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'El registro no fue eliminado']);
        }
    }


    public function ajax_all(Request $request)
    {
        if ($request->ajax()) {
            $data = TdTipo::orderBy('nombre', 'asc')->get();
            return response()->json($data);
        }
        return  response()->json(["status" => false, "mensaje" => 'Error en request']);
    }
}
