<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;

use App\Http\Controllers\sidebar\SidebarController;
use App\Models\Student;
use App\Models\Subject;
use App\Models\Semester;
use App\Models\Subjectenrollment;
use App\Models\User;
use App\Services\Moodle\MoodleEnrollmentService;
use Illuminate\Http\Request;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Yajra\DataTables\Facades\DataTables;
use Illuminate\Support\Facades\Route;
use Barryvdh\DomPDF\Facade\Pdf as PDF;
use Illuminate\Http\Response;

class SubjectenrollmentController extends Controller
{

    public function index(Request $request)
    {
        return view('admin.matricula.alumnos_cursos.index');
    }


    public function list(Request $request)
    {
        $semester = Semester::where('estado', 1)->first();
        $idstudent = $request->input('idstudent');

        if ($request->ajax()) {
            // query
            $data = DB::table('asignaturas as su')
                ->join('matriculas_semestres as seen', 'su.semester_id', '=', 'seen.semester_id')
                ->leftJoin('matriculas_asignaturas as suen', function ($join) {
                    $join->on('su.id', '=', 'suen.subject_id')
                        ->on('seen.student_id', '=', 'suen.student_id');
                })
                ->join('estudiantes as st', 'seen.student_id', '=', 'st.id')
                ->join('usuarios as us', 'st.user_id', '=', 'us.id')
                ->join('tipos_identificaciones AS it', 'it.id', '=', 'us.identificationtype_id')
                ->join('cursos as co', 'su.course_id', '=', 'co.id')
                ->join('periodos as pe', 'co.period_id', '=', 'pe.id')
                ->leftJoin('planes as pl', function ($join) {
                    $join->on('pe.plan_id', '=', 'pl.id')
                        ->on('pl.id', '=', 'st.plan_id');
                })
                ->join('programas as pr', 'pl.program_id', '=', 'pr.id')
                ->leftJoin('docentes as te', 'su.teacher_id', '=', 'te.id')
                ->leftJoin('usuarios as us2', 'te.user_id', '=', 'us2.id')
                ->leftJoin('tipos_identificaciones AS it2', 'it2.id', '=', 'us2.identificationtype_id')
                ->select(
                    'st.id as idstudent',
                    'st.anho_ingreso',
                    'st.estado',
                    'us.id as iduser1',
                    'it.id AS ididentificationtype',
                    'it.tipo AS tipoidenti',
                    'us.nroidenti as nroidenti1',
                    'us.nombres as nombres1',
                    'us.apellido_pa as apellido_pa1',
                    'us.apellido_ma as apellido_ma1',
                    'co.id as idcourse',
                    'co.tipo as tipocourse',
                    'co.codcurso',
                    'co.nombre as nombrecourse',
                    'co.codpredecesor',
                    'co.horas',
                    'co.creditos',
                    'pe.numero as periodo',
                    'pl.nombre AS plan', //
                    'pr.nombre AS programa', //
                    'su.id as idsubject',
                    'su.seccion',
                    'su.turno',
                    'su.tipo as tiposubject',
                    'su.nota_minima',
                    'te.id as idteacher',
                    'us2.id as iduser2',
                    'it2.id AS ididentificationtype2',
                    'it2.tipo AS tipoidenti2',
                    'us2.nombres as nombres2',
                    'us2.apellido_pa as apellido_pa2',
                    'us2.apellido_ma as apellido_ma2',
                    'suen.id as idsubjectenrollment',
                    'suen.nota',
                    'suen.estado as estado_subjectenrolment',
                    DB::raw('CASE WHEN suen.id IS NOT NULL THEN "1" ELSE "0" END as relacion_estado')
                )
                ->where('su.semester_id', $semester->id)
                ->where('seen.student_id', $idstudent)
                ->orderBy('pe.numero', 'ASC')
                ->orderBy('co.nombre', 'ASC')
                ->get();

            // datatable
            return DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }
        return  response()->json(["status" => false, "mensaje" => 'No se pueden cargar los datos']);
    }


    public function list_not_enrollment_subjects(Request $request)
    {
        $semester = Semester::where('estado', 1)->first();
        $idstudent = $request->input('idstudent');
        
        if ($request->ajax()) {
            // query
            $data = DB::table('asignaturas as su')
                ->join('matriculas_semestres as seen', 'su.semester_id', '=', 'seen.semester_id')
                ->leftJoin('matriculas_asignaturas as suen', function($join) {
                    $join->on('su.id', '=', 'suen.subject_id')
                        ->on('seen.student_id', '=', 'suen.student_id');
                })
                ->join('estudiantes as st', 'seen.student_id', '=', 'st.id')
                ->join('cursos as co', 'su.course_id', '=', 'co.id')
                ->join('periodos as pe', 'co.period_id', '=', 'pe.id')
                ->select(
                    'st.id as idstudent',
                    'co.id as idcourse',
                    'co.tipo as tipocourse',
                    'co.codcurso',
                    'co.nombre as nombrecourse',
                    'co.horas',
                    'co.creditos',
                    'pe.numero as periodo',
                    'su.id as idsubject',
                    'su.seccion',
                    'su.turno',
                    'suen.estado as estado_subjectenrolment',
                )
                ->where('su.semester_id', $semester->id)
                ->where('seen.student_id', $idstudent)
                ->whereNull('suen.id')
                ->orderBy('pe.numero', 'ASC')
                ->orderBy('co.nombre', 'ASC')
                ->get();
                
            // datatable
            return DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }
        return  response()->json(["status" => false, "mensaje" => 'No se pueden cargar los datos']);
    }


    public function store(Request $request)
    {
        // Consulta donde te de la cantidad de alumnos matriculados en el curso
        $cupos = DB::table('asignaturas as a')
            ->select([
                'a.cupos as disponibles',
                DB::raw('COALESCE(COUNT(a.id), 0) as ocupados')
            ])
            ->leftJoin('matriculas_asignaturas as ma', 'ma.subject_id', '=', 'a.id')
            ->where('a.id', $request->input('txt-idsubject'))
            ->groupBy('a.cupos')
        ->first();

        // Si es mayor o igual que los cupos establecidos
        if ($cupos->ocupados >= $cupos->disponibles) {
            return response()->json(["status" => false, "mensaje" => 'Ya no hay cupos disponibles']);
        }

        $curso = DB::table('cursos as c')
            ->join('asignaturas as a', 'a.course_id', '=', 'c.id')
            ->select('a.id as idasignatura', DB::raw('SUM(c.creditos) as creditos'))
            ->where('a.id', $request->input('txt-idsubject'))
            ->groupBy('a.id')
            ->first();

        $creditos = DB::table('cursos as c')
            ->join('asignaturas as a', 'a.course_id', '=', 'c.id')
            ->join('matriculas_asignaturas as ma', 'ma.subject_id', '=', 'a.id')
            ->join('semestres as s', 's.id', '=', 'a.semester_id')
            ->join('matriculas_semestres as ms', function ($join) {
                $join->on('ms.student_id', '=', 'ma.student_id')
                    ->on('ms.semester_id', '=', 's.id');
            })
            ->select('ms.student_id as idstudent', 'ms.id as idmatricula_semestre', DB::raw('SUM(c.creditos) as total'))
            ->where('ms.semester_id', $request->input('txt-idsemester'))
            ->where('ms.student_id', $request->input('txt-idstudent'))
            ->groupBy('ms.student_id', 'ms.id')
            ->first();

        if (!$creditos) {
            $subtotal_creditos = 0;
        } else {
            $subtotal_creditos = $creditos->total;
        }

        if(($subtotal_creditos + $curso->creditos) <= 19) {
            // validar si existe
            $item = new Subjectenrollment();
            $item->student_id = $request->input('txt-idstudent');
            $item->subject_id = $request->input('txt-idsubject');
            // $item->nota = '';
            $item->estado = '1';
            if ($item->save()) {
                // // MATRICULAR EN MOODLE - INICIO
                // $moodleEnrollmentService = new MoodleEnrollmentService();

                // $student = Student::find($item->student_id);
                // $user = $student->user;
                // $mdlUserId = $user->moodle_id;
                // $subject = Subject::find($item->subject_id);
                // $subjectMoodleId = $subject->subject_moodle_category_id;

                // $moodleEnrollmentService->enrollStudentToCourse($mdlUserId,$subjectMoodleId);
                // // MATRICULAR EN MOODLE - FIN
                return response()->json(["status" => true, "mensaje" => 'Registro insertado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no insertado']);
            }
        } else {
            return response()->json(["status" => false, "mensaje" => 'El limite de créditos por semestre es 19']);
        }
    }

    public function update_estado(Request $request, $idsubjectenrollment)
    {
        // validar si existe
        $item = Subjectenrollment::find($idsubjectenrollment);
        $item->estado = '1';
        if ($item->save()) {
            return response()->json(["status" => true, "mensaje" => 'Registro insertado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'Registro no insertado']);
        }
    }


    public function destroy($idsubjectenrollment)
    {
        // Busca el registro por su ID
        $item = Subjectenrollment::find($idsubjectenrollment);

        $studentId = $item->student_id;
        $subjectId = $item->subject_id;

        // Verifica si el registro existe
        if (!$item) {
            return response()->json(["status" => false, "mensaje" => 'El registro no existe']);
        }

        // Elimina el registro de la base de datos
        if ($item->delete()) {
            // // DESMATRICULAR EN MOODLE - INICIO
            // $moodleEnrollmentService = new MoodleEnrollmentService();

            // $student = Student::find($studentId);
            // $user = $student->user;
            // $mdlUserId = $user->moodle_id;
            // $subject = Subject::find($subjectId);
            // $subjectMoodleId = $subject->subject_moodle_category_id;

            // $moodleEnrollmentService->unenrollStudentFromCourse($mdlUserId,$subjectMoodleId);
            // // DESMATRICULAR EN MOODLE - FIN

            return response()->json(["status" => true, "mensaje" => 'El registro fue eliminado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'El registro no fue eliminado']);
        }
    }


    public function list_historial(Request $request)
    {
        $idstudent = $request->input('idstudent');
        $idcourse = $request->input('idcourse');

        if ($request->ajax()) {
            // query
            $data = DB::table('matriculas_asignaturas as suen')
                ->join('asignaturas as su', 'suen.subject_id', '=', 'su.id')
                ->join('cursos as co', 'su.course_id', '=', 'co.id')
                ->join('semestres as se', 'su.semester_id', '=', 'se.id')
                ->leftJoin('docentes as te', 'su.teacher_id', '=', 'te.id')
                ->leftJoin('usuarios as us2', 'te.user_id', '=', 'us2.id')
                ->leftJoin('tipos_identificaciones AS it2', 'it2.id', '=', 'us2.identificationtype_id')
                ->select(
                    'se.id as idsemester',
                    'se.anho',
                    'se.numero',
                    'se.fecinicio',
                    'se.fecfin',
                    'co.id as idcourse',
                    'co.tipo as tipocourse',
                    'co.codcurso',
                    'co.nombre as nombrecourse',
                    'co.codpredecesor',
                    'co.horas',
                    'co.creditos',
                    'su.id as idsubject',
                    'su.seccion',
                    'su.turno',
                    'su.tipo as tiposubject',
                    'suen.nota',
                    'suen.estado',
                    'te.id as idteacher',
                    'us2.id as iduser2',
                    'it2.id AS ididentificationtype2',
                    'it2.tipo AS tipoidenti2',
                    'us2.nroidenti as nroidenti2',
                    'us2.nombres as nombres2',
                    'us2.apellido_pa as apellido_pa2',
                    'us2.apellido_ma as apellido_ma2'
                )
                ->where('suen.student_id', $idstudent)
                ->where('co.id', $idcourse)
                ->orderBy('se.anho', 'DESC')
                ->orderBy('se.numero', 'DESC')
                ->get();
            // datatable
            return DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }
        return  response()->json(["status" => false, "mensaje" => 'No se pueden cargar los datos']);
    }

    public function students_by_idsubject(Request $request)
    {
        $idsubject = $request->input('idsubject');

        if ($request->ajax()) {

            $data = Subject::join('matriculas_asignaturas', 'asignaturas.id', '=', 'matriculas_asignaturas.subject_id')
                ->join('estudiantes', 'estudiantes.id', '=', 'matriculas_asignaturas.student_id')
                ->join('usuarios', 'usuarios.id', '=', 'estudiantes.user_id')
                ->join('tipos_identificaciones AS it', 'it.id', '=', 'usuarios.identificationtype_id')
                ->join('cursos', 'cursos.id', '=', 'asignaturas.course_id')
                ->select(
                    'it.id AS ididentificationtype',
                    'it.tipo AS tipoidenti',
                    'usuarios.nroidenti',
                    DB::raw('CONCAT(usuarios.apellido_pa, " ", usuarios.apellido_ma, ", ", usuarios.nombres) AS estudiante'),
                    'cursos.nombre AS curso',
                    'matriculas_asignaturas.id AS idsubjectenrollment',
                    'matriculas_asignaturas.subject_id AS idsubject',
                    'matriculas_asignaturas.student_id AS idstudent',
                    'matriculas_asignaturas.nota',
                    'matriculas_asignaturas.estado'
                )
                ->where('asignaturas.id', $idsubject)
                ->orderBy('estudiante')
                ->get();

            return DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }
        return  response()->json(["status" => false, "mensaje" => 'Error en request']);
    }
}
