<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;

use App\Http\Controllers\sidebar\SidebarController;
use App\Models\Subject;
use App\Models\Teacher;
use App\Services\Moodle\MoodleEnrollmentService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use Yajra\DataTables\Facades\DataTables;

class SubjectController extends Controller
{


    public function index(Request $request)
    {
        return view('admin.cursos.asignaturas.index');
    }



    public function list(Request $request)
    {

        $idsemester = $request->input('idsemester');
        $idperiod = $request->input('idperiod');

        if ($request->ajax()) {
            // query
            $data = DB::table('asignaturas as su')
                ->join('semestres as se', 'su.semester_id', '=', 'se.id')
                ->join('cursos as co', 'su.course_id', '=', 'co.id')
                ->join('periodos as pe', 'co.period_id', '=', 'pe.id')
                ->leftJoin('docentes as te', 'su.teacher_id', '=', 'te.id')
                ->leftJoin('usuarios as us', 'te.user_id', '=', 'us.id')
                ->select(
                    'su.id as idsubject',
                    'su.seccion',
                    'su.turno',
                    'su.cupos',
                    'su.tipo as condicion',
                    'su.nota_minima',
                    'su.silabo',
                    'su.instrumentos_evaluacion',
                    'su.teacher_id',
                    'co.codcurso',
                    'co.nombre as nomcurso',
                    'co.creditos',
                    'co.horas',
                    'co.tipo',
                    'se.id as idsemester',
                    'co.id as idcourse',
                    'pe.id as idperiod',
                    'us.apellido_pa',
                    'us.apellido_ma',
                    DB::raw('EXISTS (
                        SELECT 1
                        FROM asignaturas
                        WHERE seccion = "B" AND course_id = co.id
                    ) as exist_sec_b'),
                    DB::raw('EXISTS (
                        SELECT 1
                        FROM asignaturas
                        WHERE seccion = "C" AND course_id = co.id
                    ) as exist_sec_c')
                )
                ->where('se.id', $idsemester)
                ->where('pe.id', $idperiod)
                ->orderBy('co.nombre', 'asc')
                ->orderBy('su.seccion', 'asc')
                ->orderBy('co.tipo', 'desc')
                ->get();
            // datatable
            return DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }
        return  response()->json(["status" => false, "mensaje" => 'Error: no se pueden cargar los archivos']);
    }

    public function store(Request $request)
    {

        $item = new Subject();
        // validar existencia del registro
        if (!$item) {
            abort(404);
        } else {
            // recoger datos
            $item->seccion = $request->input('txt-newseccion');
            $item->turno = 'M';
            $item->tipo = 'Regular';
            $item->cupos = $request->input('txt-cupos');;
            $item->nota_minima = '13';
            $item->course_id = $request->input('txt-idcourse');
            $item->semester_id = $request->input('txt-idsemester');
            // validar guardado
            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Registro insertado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no insertado']);
            }
        }
    }

    public function update(Request $request, $idsubject)
    {
        $itemSubject = Subject::find($idsubject);
        // validar existencia del registro
        if (!$itemSubject) {
            abort(404);
        } else {
            // recoger datos
            $itemSubject->seccion = $request->input('txt-seccion');
            $itemSubject->turno = $request->input('txt-turno');
            $itemSubject->tipo = $request->input('txt-sub_tipo');
            $itemSubject->cupos = $request->input('txt-cupos');
            // guardar silabo
            if ($request->hasFile('txt-silabo')) {
                // Validador
                $validator = Validator::make($request->all(), [
                    'txt-silabo' => 'required|file|mimes:pdf|max:500', // Valida PDF y tamaño máximo de 2MB
                ], [
                    'txt-silabo.file' => 'El silabo PDF es requerido.',
                    'txt-silabo.mimes' => 'El silabo debe ser un PDF.',
                    'txt-silabo.max' => 'El tamaño del silabo no debe superar los 2MB.',
                ]);

                if ($validator->fails()) {
                    return response()->json([
                        "status" => false,
                        "errors" => $validator->errors(),
                    ]);
                } else {
                    // $folderName = $idsubject . '/' . 'reservas_licencias';
                    Storage::disk('local')->makeDirectory('subjects/' . $idsubject);   // creamos la carpeta en el disco local
                    // documento
                    $archivo = $request->file('txt-silabo');   // obtenemos el archivo
                    $archivo->storeAs('subjects/' . $idsubject, 'silabo.pdf');  // guardado (ruta,nombre del archivo)
                    // update bd
                    $filePath = 'subjects/' . $idsubject . '/silabo.pdf';  // ruta del archivo
                    $itemSubject->silabo = $filePath;
                }
            }
            // guardar instrumentos de evaluacion
            if ($request->hasFile('txt-instrumentos_evaluacion')) {
                // Validador
                $validator = Validator::make($request->all(), [
                    'txt-instrumentos_evaluacion' => 'required|file|mimes:pdf|max:500', // Valida PDF y tamaño máximo de 2MB
                ], [
                    'txt-instrumentos_evaluacion.file' => 'El instrumento de evaluación PDF es requerido.',
                    'txt-instrumentos_evaluacion.mimes' => 'El instrumento de evaluación debe ser un PDF.',
                    'txt-instrumentos_evaluacion.max' => 'El tamaño del instrumento de evaluación no debe superar los 2MB.',
                ]);

                if ($validator->fails()) {
                    return response()->json([
                        "status" => false,
                        "errors" => $validator->errors(),
                    ]);
                } else {
                    // $folderName = $idsubject . '/' . 'reservas_licencias';
                    Storage::disk('local')->makeDirectory('subjects/' . $idsubject);   // creamos la carpeta en el disco local
                    // documento
                    $archivo = $request->file('txt-instrumentos_evaluacion');   // obtenemos el archivo
                    $archivo->storeAs('subjects/' . $idsubject, 'instrumentos_evaluacion.pdf');  // guardado (ruta,nombre del archivo)
                    // update bd
                    $filePath = 'subjects/' . $idsubject . '/instrumentos_evaluacion.pdf';  // ruta del archivo
                    $itemSubject->instrumentos_evaluacion = $filePath;
                }
            }
            // validar guardado
            if ($itemSubject->save()) {
                return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
            }
        }
    }


    public function update_teacher(Request $request, $idsubject)
    {

        // $validator = Validator::make($request->all(), [
        //     'text_codigo_programa_name' => 'required|min:5',
        //     'text_name_programa_name' => 'required',
        //     'nivel_formativo' => 'required'
        // ]);

        // if ($validator->fails()) {
        //     return response()->json([
        //         "status" => false,
        //         "mensaje" => $validator->errors()
        //     ]);
        // }

        $itemSubject = Subject::find($idsubject);
        // validar existencia del registro
        if (!$itemSubject) {
            abort(404);
        } else {
            // recoger datos
            $newTeacherId = $request->input('txt-idteacher');
            $oldTeacherId = $itemSubject->teacher_id;
            $itemSubject->teacher_id = $newTeacherId;
            // validar guardado
            if ($itemSubject->save()) {
                // $moodleEnrollmentService = new MoodleEnrollmentService();

                // $subject = Subject::find($idsubject);
                // $subjectMoodleId = $subject->subject_moodle_category_id;
                // // DESMATRICULAR EN MOODLE - INICIO
                // if ($newTeacherId == null) {
                //     $teacher = Teacher::find($oldTeacherId);
                //     $user = $teacher->user;
                //     $mdlUserId = $user->moodle_id;
                //     $moodleEnrollmentService->unenrollTeacherFromCourse($mdlUserId, $subjectMoodleId);
                // }
                // // DESMATRICULAR EN MOODLE - FIN
                // // MATRICULAR EN MOODLE - INICIO
                // else {
                //     $teacher = Teacher::find($newTeacherId);
                //     $user = $teacher->user;
                //     $mdlUserId = $user->moodle_id;
                //     $moodleEnrollmentService->enrollTeacherToCourse($mdlUserId, $subjectMoodleId);
                // }
                // // MATRICULAR EN MOODLE - FIN


                return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
            }
        }
    }


    public function destroy($id)
    {
        $item = Subject::find($id);

        // validar existencia del registro
        if (!$item) {
            return response()->json(["status" => false, "mensaje" => 'El registro no existe']);
        }

        // validar eliminación
        if ($item->delete()) {
            return response()->json(["status" => true, "mensaje" => 'El registro fue eliminado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'El registro no fue eliminado']);
        }
    }

    public function analisisRendimiento($idsubject)
    {
        try {
            // === 1. Datos del curso ===
            $curso = DB::table('asignaturas as su')
                ->join('cursos as co', 'su.course_id', '=', 'co.id')
                ->select('su.id as idsubject', 'su.seccion', 'co.nombre as curso_nombre', 'co.codcurso')
                ->where('su.id', $idsubject)
                ->first();

            if (!$curso) {
                return response()->json(["status" => false, "mensaje" => 'Curso no encontrado']);
            }

            // === 2. Estudiantes matriculados ===
            $estudiantes = DB::table('matriculas_asignaturas as ma')
                ->join('estudiantes as e', 'ma.student_id', '=', 'e.id')
                ->join('usuarios as u', 'e.user_id', '=', 'u.id')
                ->select(
                    'u.id',
                    'ma.id as enrollment_id',
                    'ma.student_id',
                    DB::raw("CONCAT(COALESCE(u.nombres, ''), ' ', COALESCE(u.apellido_pa, ''), ' ', COALESCE(u.apellido_ma, '')) as estudiante"),
                    'e.id as codigo'
                )
                ->where('ma.subject_id', $idsubject)
                ->get();

            if ($estudiantes->isEmpty()) {
                $estudiantes = DB::table('matriculas_asignaturas as ma')
                    ->join('usuarios as u', 'ma.student_id', '=', 'u.id')
                    ->leftJoin('estudiantes as e', 'u.id', '=', 'e.user_id')
                    ->select(
                        'u.id',
                        'ma.id as enrollment_id',
                        'ma.student_id',
                        DB::raw("CONCAT(COALESCE(u.nombres, ''), ' ', COALESCE(u.apellido_pa, ''), ' ', COALESCE(u.apellido_ma, '')) as estudiante"),
                        DB::raw("COALESCE(e.id, u.id) as codigo")
                    )
                    ->where('ma.subject_id', $idsubject)
                    ->get();
            }

            // === 3. Estructura de evaluación (indicadores, actividades, notas) ===
            $estructuraEvaluacion = DB::table('indicadores as i')
                ->join('actividades as a', 'i.id', '=', 'a.indicator_id')
                ->join('notas as n', 'a.id', '=', 'n.activity_id')
                ->where('i.subject_id', $idsubject)
                ->select(
                    'i.id as indicador_id',
                    'i.nombre as indicador_nombre',
                    'a.id as actividad_id',
                    'a.nombre as actividad_nombre',
                    'n.id as nota_id',
                    'n.nombre as evaluacion_nombre',
                    DB::raw('(n.porcentaje * 100) as porcentaje')
                )
                ->orderBy('i.id')
                ->orderBy('a.id')
                ->orderBy('n.id')
                ->get();

            // === 4. Notas de estudiantes ===
            $notasEstudiantes = DB::table('notas_estudiantes as ne')
                ->join('matriculas_asignaturas as ma', 'ne.subjectenrollment_id', '=', 'ma.id')
                ->where('ma.subject_id', $idsubject)
                ->select(
                    'ne.id',
                    'ne.subjectenrollment_id',
                    'ne.grade_id',
                    'ne.nota as nota_estudiante',
                    'ne.asistencia'
                )
                ->get();

            // === 5. Si no hay estudiantes ===
            if ($estudiantes->isEmpty()) {
                return response()->json([
                    "status" => true,
                    "curso" => $curso,
                    "estudiantes" => [],
                    "estructura_evaluacion" => $estructuraEvaluacion->groupBy(['indicador_id', 'actividad_id']),
                    "notas_estudiantes" => $notasEstudiantes,
                    "metricas" => [
                        "total_estudiantes" => 0,
                        "promedio" => 0,
                        "porcentaje_aprobacion" => 0,
                        "estudiantes_riesgo" => 0,
                        "nota_minima" => $curso->nota_minima ?? 11
                    ],
                    "graficos" => [
                        "distribucion" => [
                            'labels' => ['0-5', '5-10', '10-15', '15-20'],
                            'data' => [0, 0, 0, 0]
                        ],
                        "estado" => [
                            'labels' => ['Aprobados', 'Reprobados', 'En curso'],
                            'data' => [0, 0, 0]
                        ]
                    ],
                    "estudiantesRiesgo" => [],
                    "mensaje" => "No hay estudiantes matriculados en este curso"
                ]);
            }

            // === 6. Calcular notas y estado por estudiante ===
            $indicadores = $estructuraEvaluacion->groupBy('indicador_id');
            $totalIndicadores = $indicadores->count();

            $estudiantesConNotas = $estudiantes->map(function ($estudiante) use ($notasEstudiantes, $indicadores, $totalIndicadores) {
                $notaFinal = 0;
                $tieneNotas = false;

                foreach ($indicadores as $actividadesIndicador) {
                    $pesoIndicador = 1 / $totalIndicadores; // cada indicador vale lo mismo
                    $totalPorcentajeNotas = $actividadesIndicador->sum('porcentaje');
                    $notaIndicador = 0;

                    foreach ($actividadesIndicador as $evaluacion) {
                        $notaEst = $notasEstudiantes
                            ->where('subjectenrollment_id', $estudiante->enrollment_id)
                            ->where('grade_id', $evaluacion->nota_id)
                            ->first();

                        if ($notaEst && $notaEst->nota_estudiante !== null) {
                            $pesoNota = $evaluacion->porcentaje / $totalPorcentajeNotas;
                            $notaIndicador += $notaEst->nota_estudiante * $pesoNota;
                            $tieneNotas = true;
                        }
                    }

                    $notaFinal += $notaIndicador * $pesoIndicador;
                }

                // Estado (validado contra 11 fijo)
                if (!$tieneNotas) {
                    $estado = "En curso";
                } elseif ($notaFinal >= 11) {
                    $estado = "Aprobado";
                } else {
                    $estado = "Reprobado";
                }

                return (object)[
                    'id' => $estudiante->id,
                    'enrollment_id' => $estudiante->enrollment_id,
                    'student_id' => $estudiante->student_id,
                    'estudiante' => $estudiante->estudiante,
                    'codigo' => $estudiante->codigo,
                    'nota' => round($notaFinal, 2),
                    'estado' => $estado
                ];
            });

            $estudiantesConNotas = $estudiantesConNotas->sortByDesc('nota')->values();

            // === 7. Métricas generales ===
            $totalEstudiantes = $estudiantesConNotas->count();
            $sumaNotas = $estudiantesConNotas->sum('nota');
            $promedio = $totalEstudiantes > 0 ? $sumaNotas / $totalEstudiantes : 0;

            $aprobados = $estudiantesConNotas->where('estado', 'Aprobado')->count();
            $reprobados = $estudiantesConNotas->where('estado', 'Reprobado')->count();
            $enCurso = $estudiantesConNotas->where('estado', 'En curso')->count();
            $porcentajeAprobacion = $totalEstudiantes > 0 ? ($aprobados / $totalEstudiantes) * 100 : 0;

            // === Métricas por indicador ===
            $metricasIndicadores = [];
            foreach ($indicadores as $indicadorId => $actividadesIndicador) {
                $indicador = $actividadesIndicador->first();
                $totalPorcentaje = $actividadesIndicador->sum('porcentaje');

                $sumaNotasIndicador = 0;
                $contadorNotas = 0;

                foreach ($actividadesIndicador as $actividad) {
                    $notasActividad = $notasEstudiantes->where('grade_id', $actividad->nota_id);
                    foreach ($notasActividad as $nota) {
                        if ($nota->nota_estudiante !== null) {
                            $sumaNotasIndicador += $nota->nota_estudiante;
                            $contadorNotas++;
                        }
                    }
                }

                $promedioIndicador = $contadorNotas > 0 ? $sumaNotasIndicador / $contadorNotas : 0;

                $metricasIndicadores[] = [
                    'indicador_id' => $indicadorId,
                    'indicador_nombre' => $indicador->indicador_nombre,
                    'total_actividades' => $actividadesIndicador->count(),
                    'total_porcentaje' => $totalPorcentaje,
                    'promedio_indicador' => round($promedioIndicador, 2)
                ];
            }


            // === 8. Distribución para gráficos ===
            $distribucion = [
                'labels' => ['0-5', '5-10', '10-15', '15-20'],
                'data' => [
                    $estudiantesConNotas->whereBetween('nota', [0, 5])->count(),
                    $estudiantesConNotas->whereBetween('nota', [5, 10])->count(),
                    $estudiantesConNotas->whereBetween('nota', [10, 15])->count(),
                    $estudiantesConNotas->whereBetween('nota', [15, 20])->count()
                ]
            ];

            $estadoGrafico = [
                'labels' => ['Aprobados', 'Reprobados', 'En curso'],
                'data' => [$aprobados, $reprobados, $enCurso]
            ];

            // === 9. Estudiantes en riesgo ===
            $estudiantesRiesgoLista = $estudiantesConNotas
                ->where('estado', 'Reprobado')
                ->map(function ($estudiante) use ($notasEstudiantes) {
                    $notasEstudiante = $notasEstudiantes->where('subjectenrollment_id', $estudiante->enrollment_id);
                    return [
                        'id' => $estudiante->id,
                        'estudiante' => $estudiante->estudiante,
                        'codigo' => $estudiante->codigo,
                        'nota' => $estudiante->nota,
                        'estado' => $estudiante->estado,
                        'evaluaciones_bajas' => $notasEstudiante->where('nota_estudiante', '<', 11)->count(),
                        'asistencias_bajas' => $notasEstudiante->where('asistencia', 0)->count()
                    ];
                })->values();

            // === 10. Respuesta final ===
            return response()->json([
                "status" => true,
                "curso" => $curso,
                "estudiantes" => $estudiantesConNotas,
                "estructura_evaluacion" => $estructuraEvaluacion->groupBy(['indicador_id', 'actividad_id']),
                "notas_estudiantes" => $notasEstudiantes,
                "metricas" => [
                    "total_estudiantes" => $totalEstudiantes,
                    "promedio" => round($promedio, 2),
                    "porcentaje_aprobacion" => round($porcentajeAprobacion, 2),
                    "estudiantes_riesgo" => $reprobados
                ],
                "metricas_indicadores" => $metricasIndicadores,
                "graficos" => [
                    "distribucion" => $distribucion,
                    "estado" => $estadoGrafico
                ],
                "estudiantesRiesgo" => $estudiantesRiesgoLista
            ]);
        } catch (\Exception $e) {
            return response()->json([
                "status" => false,
                "mensaje" => "Error al generar el análisis: " . $e->getMessage()
            ]);
        }
    }



    public function ajax_all_by_idplan(Request $request, $idplan, $idsemester)
    {
        if ($request->ajax()) {

            $data = Subject::join('cursos', 'cursos.id', '=', 'asignaturas.course_id')
                ->join('periodos', 'periodos.id', '=', 'cursos.period_id')
                ->join('semestres', 'semestres.id', '=', 'asignaturas.semester_id')
                ->select(
                    'periodos.id AS idperiod',
                    'periodos.numero AS periodo',
                    'cursos.id AS idcourse',
                    'cursos.nombre AS curso',
                    'asignaturas.id AS idsubject',
                    'asignaturas.seccion',
                    'asignaturas.turno',
                    'asignaturas.tipo',
                    'asignaturas.nota_minima'
                )
                ->where('periodos.plan_id', $idplan)
                ->where('semestres.id', $idsemester)
                ->orderBy('periodo', 'asc')
                ->orderBy('curso', 'asc')
                ->orderBy('asignaturas.seccion', 'asc')
                ->get();

            return response()->json($data);
        }
        return  response()->json(["status" => false, "mensaje" => 'Error en request']);
    }


    public function ajax_all_by_idprogram_by_idadmin(Request $request, $idprogram, $idsemester)
    {
        if ($request->ajax()) {

            // $docentedata = Auth::User()->teachers;
            // $idteacher = $docentedata[0]->id;

            $data = DB::table('asignaturas as a')
                ->join('cursos as cu', 'cu.id', '=', 'a.course_id')
                ->join('periodos as pe', 'pe.id', '=', 'cu.period_id')
                ->join('semestres as se', 'se.id', '=', 'a.semester_id')
                ->join('planes as pl', 'pl.id', '=', 'pe.plan_id')
                ->select(
                    'pe.id as idperiod',
                    'pe.numero as periodo',
                    'cu.id as idcourse',
                    'cu.nombre as curso',
                    'a.id as idsubject',
                    'a.tipo as tipo',
                    'pl.nombre as plan'
                )
                ->where('se.id', '=', $idsemester)
                // ->where('a.teacher_id', '=', $idteacher)
                ->where('pl.program_id', '=', $idprogram)
                ->orderBy('periodo', 'asc')
                ->orderBy('curso', 'asc')
                ->orderBy('a.seccion', 'asc')
                ->get();

            return response()->json($data);
        }
        return  response()->json(["status" => false, "mensaje" => 'Error en request']);
    }

    public function ajax_all_by_idprogram_by_idteacher(Request $request, $idprogram, $idsemester)
    {
        if ($request->ajax()) {

            $docentedata = Auth::User()->teachers;
            $idteacher = $docentedata[0]->id;

            $data = DB::table('asignaturas as a')
                ->join('cursos as cu', 'cu.id', '=', 'a.course_id')
                ->join('periodos as pe', 'pe.id', '=', 'cu.period_id')
                ->join('semestres as se', 'se.id', '=', 'a.semester_id')
                ->join('planes as pl', 'pl.id', '=', 'pe.plan_id')
                ->select(
                    'pe.id as idperiod',
                    'pe.numero as periodo',
                    'cu.id as idcourse',
                    'cu.nombre as curso',
                    'a.id as idsubject',
                    'a.tipo as tipo',
                    'pl.nombre as plan'
                )
                ->where('se.id', '=', $idsemester)
                ->where('a.teacher_id', '=', $idteacher)
                ->where('pl.program_id', '=', $idprogram)
                ->orderBy('periodo', 'asc')
                ->orderBy('curso', 'asc')
                ->orderBy('a.seccion', 'asc')
                ->get();

            return response()->json($data);
        }
        return  response()->json(["status" => false, "mensaje" => 'Error en request']);
    }
}
