<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Models\Concepto;
use App\Models\Pago;
use App\Models\Semester;
use App\Models\Semesterenrollment;
use App\Models\Studentdocument;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;
use Yajra\DataTables\Facades\DataTables;

class StudentdocumentController extends Controller
{
    //
    public function index(Request $request)
    {
        return view('admin.matricula.reservas_licencias.index');
    }

    public function list(Request $request)
    {
        //
        if ($request->ajax()) {
            // query
            $data = DB::table('estudiantes AS st')
                ->select(
                    'st.id AS idstudent',
                    DB::raw('CONCAT(pr.nombre, " - Plan ", pl.nombre) AS programa_plan'),
                    DB::raw('CONCAT(us.nroidenti) AS identificacion'),
                    DB::raw('CONCAT(us.apellido_pa, " ", us.apellido_ma, ", ", us.nombres) AS estudiante'),
                    'doc.id AS idstudentdocument',
                    'doc.fecha_solicitud AS fecha_solicitud',
                    'doc.fecha_inicio AS fecha_inicio',
                    DB::raw('DATE_FORMAT(doc.fecha_solicitud, "%d/%m/%Y") AS fecha_solicitud2'),
                    DB::raw('DATE_FORMAT(doc.fecha_inicio, "%d/%m/%Y") AS fecha_inicio2'),
                    'doc.nombre AS nombredocument',
                    'doc.ruta',
                    'doc.estado AS estadoregistro',
                    'doc.descripcion',
                    DB::raw("
                        CASE
                            WHEN DATE_ADD(doc.fecha_inicio, INTERVAL 2 YEAR) >= CURDATE()
                                THEN 'VIGENTE'
                            ELSE 'VENCIDO'
                        END AS estado_licencia
                    "),
                    'pa.estado AS estado_pago'
                )
                ->join('documentos_estudiantes AS doc', 'st.id', '=', 'doc.student_id')
                ->join('usuarios AS us', 'st.user_id', '=', 'us.id')
                ->join('tipos_identificaciones AS it', 'it.id', '=', 'us.identificationtype_id')
                ->join('planes AS pl', 'st.plan_id', '=', 'pl.id')
                ->join('programas AS pr', 'pl.program_id', '=', 'pr.id')
                ->join('pagos AS pa', 'pa.id', '=', 'doc.payment_id')
                ->orderBy('doc.fecha_inicio', 'desc')
                ->get();

            // datatable
            return DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }

        return response()->json(['status' => false, 'mensaje' => 'Error: no se pueden cargar los archivos']);
    }

    public function store(Request $request)
    {
        $semestre = Semester::where('estado', 1)->first();
        $matricula = Semesterenrollment::where('semester_id', $semestre->id)->where('student_id', $request->input('txt-students'))->first();
        if ($matricula) {
            return response()->json(['status' => false, 'mensaje' => 'El estudiante está matriculado en el semestre actual']);
        }
        //
        $idstudent = $request->input('txt-students');
        $tipo_solicitud = $request->input('txt-nombre');
        $resultado = Studentdocument::where('student_id', $idstudent)
            ->where('nombre', $tipo_solicitud)
            ->where('estado', 1)->first();

        if ($resultado == null) {
            $item = new Studentdocument();
            $item->fecha_solicitud = $request->input('txt-fecha_solicitud');
            $item->fecha_inicio = $request->input('txt-fecha_inicio');
            $item->nombre = $request->input('txt-nombre');
            $item->ruta = '--';
            $item->descripcion = $request->input('txt-descripcion');
            $item->estado = 1;
            $item->student_id = $idstudent;

            if ($request->hasFile('txt-document')) {
                // Validador
                $validator = Validator::make($request->all(), [
                    'txt-document' => 'file|mimes:pdf|max:5000', // Valida PDF y tamaño máximo de 2MB
                ], [
                    'txt-document.mimes' => 'El archivo debe ser un PDF.',
                    'txt-document.max' => 'El tamaño del archivo no debe superar los 5 MB.',
                ]);

                if ($validator->fails()) {
                    return response()->json(['status' => false, 'errors' => $validator->errors()]);
                } else {
                    $folderName = 'public/students/'.$idstudent.'/'.'reservas_licencias';
                    Storage::disk('local')->makeDirectory($folderName);   // creamos la carpeta en el disco local
                    $archivo = $request->file('txt-document');   // obtenemos el archivo
                    $item->save();
                    $lastInsertId = $item->id;
                    $archivo->storeAs($folderName, $lastInsertId.'.pdf');
                    $filePath = $folderName.'/'.$lastInsertId.'.pdf';
                    $item->ruta = $filePath;
                }
            }

            $item_concepto = Concepto::find(2);

            $item_pago = new Pago();
            $item_pago->student_id = $idstudent;
            $item_pago->concepto_id = $item_concepto->id;
            $item_pago->administrator_id = Auth::user()->administradores[0]->id;
            $item_pago->fecha = $request->input('txt-fecha_inicio');
            $item_pago->monto_inicial = $item_concepto->monto;
            if ($item->nombre == 'Reserva de Matricula') {
                $item_pago->descuento = 100;
                $item_pago->monto_final = 0;
                $item_pago->estado = 1;
            } else {
                $item_pago->descuento = 0;
                $item_pago->monto_final = $item_concepto->monto;
                $item_pago->estado = 0;
            }
            $item_pago->documento = '--';
            $item_pago->save();

            $item->payment_id = $item_pago->id;

            if ($item->save()) {
                return response()->json(['status' => true, 'mensaje' => 'Registro insertado']);
            } else {
                return response()->json(['status' => false, 'mensaje' => 'Ruta no insertada correctamente']);
            }
        } else {
            return response()->json(['status' => false, 'mensaje' => 'Hay una licencia activa, desactivela para continuar']);
        }
    }

    public function update(Request $request, $idstudentdocument)
    {
        $item = Studentdocument::find($idstudentdocument);
        $idstudent = $request->input('txt-students');
        $tipo_solicitud = $request->input('txt-nombre');
        $resultado = Studentdocument::where('student_id', $idstudent)
        ->where('nombre', $tipo_solicitud)
        ->where('id', '!=', $idstudentdocument)->where('estado', 1)->first();

        $idstudent = $request->input('txt-students') ? $request->input('txt-students') : $item->student_id;

        if ($resultado == null) {
            $item = Studentdocument::find($idstudentdocument);
            $item->fecha_solicitud = $request->input('txt-fecha_solicitud');
            $item->fecha_inicio = $request->input('txt-fecha_inicio');
            $item->nombre = $request->input('txt-nombre');
            $item->ruta = '--';
            $item->descripcion = $request->input('txt-descripcion');
            $item->student_id = $idstudent;

            if ($request->hasFile('txt-document')) {
                // Validador
                $validator = Validator::make($request->all(), [
                    'txt-document' => 'file|mimes:pdf|max:5000', // Valida PDF y tamaño máximo de 2MB
                ], [
                    'txt-document.mimes' => 'El archivo debe ser un PDF.',
                    'txt-document.max' => 'El tamaño del archivo no debe superar los 5 MB.',
                ]);

                if ($validator->fails()) {
                    return response()->json(['status' => false, 'errors' => $validator->errors()]);
                } else {
                    $folderName = 'public/students/'.$idstudent.'/'.'reservas_licencias';
                    Storage::disk('local')->makeDirectory($folderName);
                    $archivo = $request->file('txt-document');
                    $item->save();
                    $lastInsertId = $item->id;
                    $archivo->storeAs($folderName, $lastInsertId.'.pdf');
                    $filePath = $folderName.'/'.$lastInsertId.'.pdf';
                    $item->ruta = $filePath;
                }
            }

            $item_concepto = Concepto::find(2);

            $item_pago = Pago::find($item->payment_id);
            $item_pago->student_id = $idstudent;
            $item_pago->concepto_id = $item_concepto->id;
            $item_pago->administrator_id = Auth::user()->administradores[0]->id;
            $item_pago->fecha = $request->input('txt-fecha_inicio');
            $item_pago->monto_inicial = $item_concepto->monto;
            if ($item->nombre == 'Reserva de Matricula') {
                $item_pago->descuento = 100;
                $item_pago->monto_final = 0;
                $item_pago->estado = 1;
            } else {
                $item_pago->descuento = 0;
                $item_pago->monto_final = $item_concepto->monto;
            }
            $item_pago->save();

            if ($item->save()) {
                return response()->json(['status' => true, 'mensaje' => 'Registro insertado']);
            } else {
                return response()->json(['status' => false, 'mensaje' => 'Ruta no insertada correctamente']);
            }
        } else {
            return response()->json(['status' => false, 'mensaje' => 'Hay una licencia activa, desactivela para continuar']);
        }
    }

    public function destroy($idstudentdocument)
    {
        // Busca el registro por su id
        $item = Studentdocument::find($idstudentdocument);

        // Verifica si el registro existe
        if (! $item) {
            return response()->json(['status' => false, 'mensaje' => 'El registro no existe']);
        }

        $file = storage_path('app/').$item->ruta;
        if (File::exists($file)) {
            File::delete($file);
        }

        // Elimina el registro de la base de datos
        if ($item->delete()) {
            return response()->json(['status' => true, 'mensaje' => 'El registro fue eliminado']);
        } else {
            return response()->json(['status' => false, 'mensaje' => 'El registro no fue eliminado']);
        }
    }

    public function updateestado(Request $request, $idstudentdocument)
    {

        $item = Studentdocument::find($idstudentdocument);

        // validar existencia del registro
        if (! $item) {
            abort(404);
        } else {
            // recoger datos
            $item->estado = $request->input('txt-estado');
            // validar guardado
            if ($item->save()) {
                return response()->json(['status' => true, 'mensaje' => 'Estado actualizado']);
            } else {
                return response()->json(['status' => false, 'mensaje' => 'Estado no actualizado']);
            }
        }
    }
}
