<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;

use App\Http\Controllers\sidebar\SidebarController;
use App\Models\Student;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Yajra\DataTables\Facades\DataTables;
use Illuminate\Support\Facades\Hash;

class StudentProfileController extends Controller
{

    public function index(Request $request)
    {

        return view('alumno.profile.index');
    }


    public function data(Request $request)
    {
        $user = Auth::user();
        $data = $user->students;
        $idstudent = $data[0]->id;

        if ($request->ajax()) {

            $data = DB::table('estudiantes AS st')
                ->join('usuarios AS us', 'us.id', '=', 'st.user_id')
                ->join('tipos_identificaciones AS it', 'it.id', '=', 'us.identificationtype_id')
                ->join('generos AS ge', 'ge.id', '=', 'us.genre_id')
                ->join('ubigeos AS ub', 'ub.id', '=', 'us.ubigeo_id')
                ->join('planes AS pl', 'pl.id', '=', 'st.plan_id')
                ->join('programas AS pr', 'pr.id', '=', 'pl.program_id')
                ->select(
                    'pr.codprograma',
                    'pr.nombre AS programa',
                    'pr.nivel_formativo',
                    'pl.nombre AS plan',
                    'pl.tipo',
                    'pl.modalidad',
                    'pl.enfoque',
                    'st.anho_ingreso',
                    'st.estado',
                    'us.id AS iduser',
                    'it.id AS ididentificationtype',
                    'it.tipo AS tipoidenti',
                    'us.nroidenti',
                    'us.nombres',
                    DB::raw("CONCAT(it.tipo, ' - ', us.nroidenti) as identificacion"),
                    DB::raw("CONCAT(us.nombres, ', ',us.apellido_pa, ' ', us.apellido_ma) AS user"),
                    'us.fecnac',
                    'us.correo',
                    'us.telefono',
                    'us.celular',
                    'us.direccion',
                    'us.ubigeo_id AS idubigeo',
                    'ge.id AS idgenero',
                    'ge.nombre AS genero',
                    'ub.id AS idubigeo',
                    DB::raw('SUBSTRING(ub.id, 1, 2) AS iddepartamento'),
                    'ub.departamento',
                    DB::raw('SUBSTRING(ub.id, 3, 2) AS idprovincia'),
                    'ub.provincia',
                    DB::raw('SUBSTRING(ub.id, 5, 2) AS iddistrito'),
                    'ub.distrito'
                )
                ->where('st.id', $idstudent)
                ->get();


            return response()->json($data);
        }
        return  response()->json(["status" => false, "mensaje" => 'Error en request']);
    }


    public function update(Request $request)
    {
        $id = Auth::user()->id;

        $item = User::find($id);

        // validar existencia del registro
        if (!$item) {
            abort(404);
        } else {

            // $item->genre_id = $request->input('txt_genero');
            $item->fecnac = $request->input('txt_fecnac');
            $item->correo = $request->input('txt_correo');
            $item->telefono = $request->input('txt_telefono');
            $item->celular = $request->input('txt_celular');
            $item->direccion = $request->input('txt_direccion');
            $idubigeo = $request->input('txt_departamento') . $request->input('txt_provincia') . $request->input('txt_distrito');
            $item->ubigeo_id = $idubigeo;
            // validar guardado
            if ($item->save()) {
                // El guardado fue exitoso
                return response()->json(["status" => true, "mensaje" => 'Datos actualizados']);
            } else {
                // El guardado falló
                return response()->json(["status" => false, "mensaje" => 'Datos no actualizados']);
            }
        }
    }

    public function update_password(Request $request)
    {
        $id = Auth::user()->id;
        $password = Auth::user()->password;
        $pass_actual = $request->input('txt_password1');
        $pass_nueva = $request->input('txt_password2');

        if ( Hash::check($pass_actual, $password) ) {

            $item = User::find($id);

            // validar existencia del registro
            if (!$item) {
                abort(404);
            } else {
                // recoger datos
                $item->password = $request->input('txt_password2');
                // validar guardado
                if ($item->save()) {
                    return response()->json(["status" => true, "mensaje" => 'Contraseña actualizada']);
                } else {
                    return response()->json(["status" => false, "mensaje" => 'Contraseña no actualizada']);
                }
            }

        } else {
            return response()->json(["status" => false, "mensaje" => 'Contraseña no actualizada']);
        }


    }
}
