<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;

use App\Http\Controllers\sidebar\SidebarController;
use App\Models\Administrator;
use App\Models\Course;
use App\Models\Period;
use App\Models\Semester;
use App\Models\Semesterperiod;
use App\Models\Subject;
use App\Models\User;
use App\Services\Moodle\MoodleCategoryService;
use App\Services\Moodle\MoodleCourseService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;
use Yajra\DataTables\Facades\DataTables;

class SemesterperiodController extends Controller
{
    //

    public function index(Request $request)
    {
        return view('admin.cursos.periodos_semestre.index');
    }

    public function list(Request $request)
    {

        $idsemester = $request->input('idsemester');
        $idprogram = $request->input('idprogram');

        if ($request->ajax()) {
            // query
            $data = DB::table('semestres as se')
                ->crossJoin('periodos as pe')
                ->leftJoin('periodos_semestres as sp', function ($join) {
                    $join->on('se.id', '=', 'sp.semester_id')
                        ->on('pe.id', '=', 'sp.period_id');
                })
                ->join('planes as pl', 'pe.plan_id', '=', 'pl.id')
                ->join('programas as pr', 'pl.program_id', '=', 'pr.id')
                ->select(
                    'sp.id as idsemesterperiod',
                    'se.id as idsemester',
                    'se.anho as anhosemester',
                    'se.numero as numerosemester',
                    'se.fecinicio',
                    'se.fecfin',
                    'pr.id as idprogram',
                    'pr.codprograma',
                    'pr.nombre as nombreprogram',
                    'pr.nivel_formativo',
                    'pl.id as idplan',
                    'pl.nombre as nombreplan',
                    'pl.tipo',
                    'pl.modalidad',
                    'pl.enfoque',
                    'pe.id as idperiod',
                    'pe.numero as numeroperiod',
                    DB::raw("CASE WHEN sp.semester_id IS NOT NULL THEN '1' ELSE '0' END as relacion_estado")
                )
                ->where('se.id', $idsemester)
                ->where('pr.id', $idprogram)
                ->orderBy('pl.nombre', 'desc')  // descendente por plan 2024, 2023
                ->orderBy('pe.numero', 'asc')  // ascendente por periodo I, II, III, IV, V, VI
                ->get();
            // datatable
            return DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }
        return  response()->json(["status" => false, "mensaje" => 'Error: no se pueden cargar los archivos']);
    }



    public function store(Request $request)
    {
        $itemSemesterPeriod = new Semesterperiod();
        $itemSemesterPeriod->semester_id = $request->input('txt-idsemester');
        $itemSemesterPeriod->period_id = $request->input('txt-idperiod');

        // Guarda el nuevo registro en la base de datos
        if ($itemSemesterPeriod->save()) {

            // $moodleCategoryService = new MoodleCategoryService();
            // $moodleCourseService = new MoodleCourseService();

            // INICIO - GUARDAR SEMESTRE EN MOODLE
                // // Obtener nombre del semester: 2024-1
                // $semester = Semester::find($itemSemesterPeriod->semester_id);
                // $semesterName = "$semester->anho-$semester->numero";

                // // Obtener id de categoría de Moodle del Programa
                // $period = Period::find($itemSemesterPeriod->period_id);
                // $plan = $period->plan;
                // $program = $plan->program;
                // $programMoodleCategoryId = $program->moodle_programa_id;

                // // Buscar si el semestre tiene una categoía existente
                // $semesterPeriodWithSemesterMoodleId = Semesterperiod::where('semester_id', $itemSemesterPeriod->semester_id)->whereNotNull('moodle_parent_category_id')->first();

                // // Si no tiene crear esa categoría: 2024-1
                // if (!$semesterPeriodWithSemesterMoodleId) {
                //     // Crear Categoría de Semestre en Moodle
                //     $resultSemesterMoodle = $moodleCategoryService->create($semesterName, $programMoodleCategoryId);
                //     // Guardar Id de Moodle
                //     if (isset($resultSemesterMoodle[0]['id'])) {
                //         $moodleSemesterCategoryId = $resultSemesterMoodle[0]['id'];
                //     }
                // }
                // // Si tiene, asignarle esa categoría al valor
                // else {
                //     $moodleSemesterCategoryId = $semesterPeriodWithSemesterMoodleId->moodle_parent_category_id;
                // }

                // $itemSemesterPeriod->moodle_parent_category_id = $moodleSemesterCategoryId;
                // $itemSemesterPeriod->save();
            // FIN - GUARDAR SEMESTRE EN MOODLE


            // INICIO - GUARDAR PERIODO EN MOODLE
                // // Obtener nombre o numero de periodo: 1, 2, 3, 4, 5, 6
                // $periodNumber = $period->numero;
                // $planName = $plan->nombre;
                // $periodCategoryName = "Plan: $planName - Periodo: $periodNumber";

                // // Crear Categoría de Periodo en Moodle
                // $resultPeriodMoodle = $moodleCategoryService->create($periodCategoryName, $moodleSemesterCategoryId); // 1, 2, 3, etc
                // // Guardar Id de Moodle
                // if (isset($resultPeriodMoodle[0]['id'])) {
                //     $itemSemesterPeriod->moodle_category_id = $resultPeriodMoodle[0]['id'];
                //     $itemSemesterPeriod->save();
                // }
            // FIN - GUARDAR PERIODO EN MOODLE


            /*----- INICIO - Crear SUBJECTS espejo de los COURSES -----*/

            // Obtener todos los id's de los COURSES que existen registrados en un PERIOD
            $courseIds = Course::where('period_id', $request->input('txt-idperiod'))->pluck('id');

            // Crear array para poner toda la info de los SUBJECTS que se crearan
            $subjectsData = [];

            // Recorrer todos los id's de los COURSES existentes y crear SUBJECTS
            foreach ($courseIds as $idcurso) {

                // INICIO - GUARDAR SUBJECT EN MOODLE
                    // $course = Course::find($idcurso);
                    // $courseName = "$course->nombre - Sec. A"; // Curso X - Sec. A
                    // $courseShortName = "S$semesterName-P$periodNumber-C$course->codcurso";
                    // $courseParentCategoryId = $itemSemesterPeriod->moodle_category_id;

                    // // Crear Curso de Course en Moodle
                    // $resultCourseMoodle = $moodleCourseService->create($courseName, $courseShortName, $courseParentCategoryId);

                    // // para debugear
                    // // return response()->json(["status" => false, "courseParentCategoryId" => $resultCourseMoodle]);

                    // // Guardar Id de Moodle
                    // if (isset($resultCourseMoodle[0]['id'])) {
                    //     $subject_moodle_category_id = $resultCourseMoodle[0]['id'];
                    // }
                // FIN - GUARDAR SUBJECT EN MOODLE

                $subjectsData[] = [
                    'seccion' => 'A',
                    'turno' => 'M',
                    'tipo' => 'Regular',
                    'cupos' => '30',
                    'nota_minima' => '13',
                    'silabo' => '--',
                    'instrumentos_evaluacion' => '--',
                    'course_id' => $idcurso,
                    'semester_id' => $request->input('txt-idsemester'),
                    // 'subject_moodle_category_id' => $subject_moodle_category_id,
                ];
            };

            // Insertar todos los SUBJECTS a la base de datos
            Subject::insert($subjectsData);

            /*----- FIN - Crear SUBJECTS espejo de los COURSES -----*/

            return response()->json(["status" => true, "mensaje" => 'Asignaturas del periodo academico registradas en el periodo lectivo correctamente']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'Registro no enlazado']);
        }
    }


    public function destroy($id)
    {
        // Busca el registro por su ID
        $item = Semesterperiod::find($id);

        $period_id = $item->period_id;
        $semester_id = $item->semester_id;

        // Obtener los IDs de Moodle
        // $moodlePeriodId = $item->moodle_category_id;
        // $moodleSemesterId = $item->moodle_parent_category_id;
        // $countMoodleSemesterId = Semesterperiod::where('moodle_parent_category_id', $moodleSemesterId)->count();

        // Verifica si el registro existe
        if (!$item) {
            return response()->json(["status" => false, "mensaje" => 'El registro no existe']);
        }

        // Eliminar categoría y cursos relacionados en Moodle
        // $moodleCategoryService = new MoodleCategoryService();
        // $moodleCategoryService->delete($moodlePeriodId);

        // Eliminar categoría semestre si es el último
        // if ($countMoodleSemesterId == 1) {
        //     $moodleCategoryService->delete($moodleSemesterId);
        // }

        // Eliminar registros en la tabla 'subjects' relacionados con el período eliminado
        Subject::where('semester_id', '=', $semester_id)
            ->whereIn('course_id', function ($query) use ($period_id) {
                $query->select('id')
                    ->from('cursos')
                    ->where('period_id', '=', $period_id);
            })->delete();

        if ($item->delete()) {
            return response()->json(["status" => true, "mensaje" => 'Las asignaturas fueron eliminadas']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'El registro no fue eliminado']);
        }
    }
}
