<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;

use App\Models\Semester;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class SemesterController extends Controller
{
    public function index()
    {
        return view('admin.institucion.semestres.index');
    }


    public function list(Request $request)
    {
        if ($request->ajax()) {

            DB::statement("SET lc_time_names = 'es_ES'");

            $data = DB::table('semestres')
                ->select([
                    'id',
                    'anho',
                    'numero',
                    'tipo',
                    'fecinicio',
                    'fecfin',
                    'creditaje',
                    'porcentaje_inasistencias',
                    'nota_minima',
                    'informacion',
                    'estado',
                    'fecha_inicio_matricula',
                    'fecha_fin_matricula',
                    'fecha_inicio_notas',
                    'fecha_fin_notas',
                    'fecha_inicio_actas',
                    'fecha_fin_actas',
                    DB::raw("
                        CASE
                            WHEN fecinicio IS NULL
                            THEN 'No definido'
                            ELSE CONCAT('Del ', DATE_FORMAT(fecinicio, '%d/%m/%Y'), ' al ', DATE_FORMAT(fecfin, '%d/%m/%Y'))
                        END AS fechas_semestre
                    "),
                    DB::raw("
                        CASE
                            WHEN fecha_inicio_matricula IS NULL
                            THEN 'No definido'
                            ELSE CONCAT('Del ', DATE_FORMAT(fecha_inicio_matricula, '%d/%m/%Y'), ' al ', DATE_FORMAT(fecha_fin_matricula, '%d/%m/%Y'))
                        END AS fechas_matricula
                    "),
                    DB::raw("
                        CASE
                            WHEN fecha_inicio_notas IS NULL
                            THEN 'No definido'
                            ELSE CONCAT('Del ', DATE_FORMAT(fecha_inicio_notas, '%d/%m/%Y'), ' al ', DATE_FORMAT(fecha_fin_notas, '%d/%m/%Y'))
                        END AS fechas_notas
                    "),
                    DB::raw("
                        CASE
                            WHEN fecha_inicio_actas IS NULL
                            THEN 'No definido'
                            ELSE CONCAT('Del ', DATE_FORMAT(fecha_inicio_actas, '%d/%m/%Y'), ' al ', DATE_FORMAT(fecha_fin_actas, '%d/%m/%Y'))
                        END AS fechas_actas
                    "),
                ])
                ->orderByDesc('id')
                ->get();

            return \Yajra\DataTables\DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los archivos'
        ]);
    }


    public function store(Request $request)
    {
        $item = new Semester();
        $item->anho = $request->input('txt-anho');
        $item->numero = $request->input('txt-numero');
        $item->tipo = $request->input('txt-tipo');
        $item->fecinicio = $request->input('txt-fecinicio');
        $item->fecfin = $request->input('txt-fecfin');
        $item->informacion = $request->input('informacion');
        $item->creditaje = $request->input('txt-creditaje');
        $item->porcentaje_inasistencias = $request->input('txt-porcentaje_inasistencias');
        $item->nota_minima = $request->input('txt-nota_minima');
        $item->fecha_inicio_matricula = $request->input('txt-fecha_inicio_matricula');
        $item->fecha_fin_matricula = $request->input('txt-fecha_fin_matricula');
        $item->fecha_inicio_notas = $request->input('txt-fecha_inicio_notas');
        $item->fecha_fin_notas = $request->input('txt-fecha_fin_notas');
        $item->fecha_inicio_actas = $request->input('txt-fecha_inicio_actas');
        $item->fecha_fin_actas = $request->input('txt-fecha_fin_actas');
        $item->estado = 0;

        // Guarda el nuevo registro en la base de datos
        if ($item->save()) {
            // El guardado fue exitoso
            return response()->json([
                "status" => true,
                "mensaje" => 'Éxito: registros realizado'
            ]);
        } else {
            // El guardado falló
            return response()->json([
                "status" => false,
                "mensaje" => 'Error: registros no realizado'
            ]);
        }
    }


    public function update(Request $request, $id)
    {
        $item = Semester::find($id);

        if (!$item) {
            abort(404);
        } else {
            $item->anho = $request->input('txt-anho');
            $item->numero = $request->input('txt-numero');
            $item->tipo = $request->input('txt-tipo');
            $item->fecinicio = $request->input('txt-fecinicio');
            $item->fecfin = $request->input('txt-fecfin');
            $item->informacion = $request->input('txt-informacion');
            $item->creditaje = $request->input('txt-creditaje');
            $item->porcentaje_inasistencias = $request->input('txt-porcentaje_inasistencias');
            $item->nota_minima = $request->input('txt-nota_minima');
            $item->fecha_inicio_matricula = $request->input('txt-fecha_inicio_matricula');
            $item->fecha_fin_matricula = $request->input('txt-fecha_fin_matricula');
            $item->fecha_inicio_notas = $request->input('txt-fecha_inicio_notas');
            $item->fecha_fin_notas = $request->input('txt-fecha_fin_notas');
            $item->fecha_inicio_actas = $request->input('txt-fecha_inicio_actas');
            $item->fecha_fin_actas = $request->input('txt-fecha_fin_actas');

            if ($item->save()) {
                // El guardado fue exitoso
                return response()->json([
                    "status" => true,
                    "mensaje" => 'Éxito: registros actualizado'
                ]);
            } else {
                // El guardado falló
                return response()->json([
                    "status" => false,
                    "mensaje" => 'Error: registros no pudo ser actualizado'
                ]);
            }
        }
    }


    public function destroy($id)
    {
        // Busca el registro por su ID
        $Semester = Semester::find($id);

        // Verifica si el registro existe
        if (!$Semester) {
            return response()->json([
                "status" => false,
                "mensaje" => 'Error, el registro no existe'
            ]);
        }

        // Elimina el registro de la base de datos
        if ($Semester->delete()) {
            return response()->json([
                "status" => true,
                "mensaje" => 'Éxito, el registro fue eliminado'
            ]);
        } else {
            return response()->json([
                "status" => false,
                "mensaje" => 'Error, al eliminar registro'
            ]);
        }
    }


    public function update_estado(Request $request, $id)
    {
        $item = Semester::find($id);

        if (!$item) {
            abort(404);
        } else {
            $isActive = Semester::where('estado', 1)->where('id', '!=', $id)->exists();
            if ($isActive) {
                return response()->json(["status" => false, "mensaje" => 'Ya hay un semestre habilitado']);
            }

            $item->estado = $request->input('txt-estado');

            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Estado actualizado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'No se pudo actualizar']);
            }
        }
    }


    public function ajax_all(Request $request)
    {
        if ($request->ajax()) {

            $data = Semester::select([
                'id',
                'anho',
                'numero',
                'estado',
                DB::raw('CONCAT(anho, "-", numero) as semestres'),
            ])
                ->orderBy('anho', 'desc')
                ->orderBy('numero', 'desc')
                ->get();

            return response()->json($data);
        }
        return  response()->json(["status" => false, "mensaje" => 'Error en request']);
    }


    public function current_active(Request $request)
    {
        if ($request->ajax()) {

            $data = Semester::select([
                'id',
                DB::raw('CONCAT(anho, "-", numero) as semestre'),
            ])
                ->where('estado', 1)
                ->orderBy('anho', 'desc')
                ->orderBy('numero', 'desc')
                ->first();

            return response()->json($data);
        }
        return  response()->json(["status" => false, "mensaje" => 'Error en request']);
    }
}
