<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;

use App\Http\Controllers\sidebar\SidebarController;
use App\Models\Program;
use App\Services\Moodle\MoodleCategoryService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Storage;
use PhpOffice\PhpSpreadsheet\IOFactory;

class ProgramController extends Controller
{
    //


    public function index(Request $request)
    {
        return view('admin.institucion.programas.index');
    }

    public function listproftec(Request $request)
    {
        if ($request->ajax()) {
            $data = Program::select('id', 'nombre','codprograma', 'nivel_formativo', 'created_at')
            ->where('nivel_formativo', 'Profesional Técnico')
            ->get();

            return \Yajra\DataTables\DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los archivos'
        ]);
    }

    public function listtec(Request $request)
    {
        if ($request->ajax()) {
            $data = Program::select('id', 'nombre','codprograma', 'nivel_formativo', 'created_at')
            ->where('nivel_formativo', 'Técnico')
            ->get();

            return \Yajra\DataTables\DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los archivos'
        ]);
    }

    public function store(Request $request)
    {

        $item = new Program();
        $item->codprograma = $request->input('codprograma');
        $item->nombre = $request->input('nombreprograma');
        $item->nivel_formativo = $request->input('nivelformativo');
        // Asigna otros campos según tus necesidades

        // Servicio para categorias
        // $moodleCategoryService = new MoodleCategoryService();
        // $result = $moodleCategoryService->create($item->nombre);

        // // Verificar si la categoría fue creada exitosamente y capturar el ID
        // if (isset($result[0]['id'])) {
        //     $moodleCategoryId = $result[0]['id'];
        //     $item->moodle_programa_id = $moodleCategoryId; // Suponiendo que tienes esta columna en tu tabla 'programs'
        // } else {
        //     return response()->json([
        //         "status" => false,
        //         "mensaje" => 'Error: no se pudo obtener el ID de la categoría en Moodle'
        //     ]);
        // }

        // Guarda el nuevo registro en la base de datos
        if ($item->save()) {
            // El guardado fue exitoso
            return response()->json([
                "status" => true,
                "mensaje" => 'Éxito: registros realizado'
            ]);
        } else {
            // El guardado falló
            return response()->json([
                "status" => false,
                "mensaje" => 'Error: registros no realizado'
            ]);
        }
    }


    public function destroy($id)
    {
        // Busca el registro por su ID
        $program = Program::find($id);

        // Verifica si el registro existe
        if (!$program) {
            return response()->json([
                "status" => false,
                "mensaje" => 'Error, el registro nos existe'
            ]);
        }

        $category_id =  $program->moodle_programa_id;

        // // Servicio para categorias
        // $moodleCategoryService = new MoodleCategoryService();
        // $moodleCategoryService->delete($category_id);

        // Elimina el registro de la base de datos
        if ($program->delete()) {
            return response()->json([
                "status" => true,
                "mensaje" => 'Éxito, el registro fue eliminado'
            ]);
        } else {
            return response()->json([
                "status" => false,
                "mensaje" => 'Error, al eliminar registro'
            ]);
        }
    }


    public function ajax_all(Request $request)
    {
        if ($request->ajax()) {
            // $data = Program::all();
            $data = Program::orderBy('nombre','asc')->get();
            return response()->json($data);
        }
        return  response()->json(["status" => false, "mensaje" => 'Error en request']);
    }



    public function cargarExcelproftec(Request $request)
    {
            $fileName = "public/Plantillaprogramas/CATALOGO_PROFESIONAL_TECNICO.xlsx";


        if (Storage::disk('local')->exists($fileName)) {
            // Obtener el archivo del storage
            $filePath = storage_path('app/'.$fileName); // Ruta al archivo Excel en el almacenamiento

            $spreadsheet = IOFactory::load($filePath);
            $data = $spreadsheet->getActiveSheet()->toArray();

            // Procesar los datos y devolver la respuesta en formato JSON
            return response()->json(['data' => $data]);

        } else {
            // Mostrar un error
            return abort(404);
        }

    }

    public function cargarExceltec(Request $request)
    {

        $fileName = "public/Plantillaprogramas/CATALOGO_TECNICO.xlsx";
        if (Storage::disk('local')->exists($fileName)) {
            // Obtener el archivo del storage
            $filePath = storage_path('app/'.$fileName); // Ruta al archivo Excel en el almacenamiento

            $spreadsheet = IOFactory::load($filePath);
            $data = $spreadsheet->getActiveSheet()->toArray();

            // Procesar los datos y devolver la respuesta en formato JSON
            return response()->json(['data' => $data]);

        } else {
            // Mostrar un error
            return abort(404);
        }

    }
}
