<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;

use App\Models\OpcionRespuesta;
use App\Models\Pregunta;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class PreguntayRespuestaController extends Controller
{
    public function index(Request $request, $idencuesta)
    {
        $result = DB::table('encuestas AS e')
                    ->join('planes AS pl', 'e.plan_id', '=', 'pl.id')
                    ->select(
                        'e.id',
                        'e.titulo',
                        'e.descripcion',
                        'e.fecha_inicio',
                        'e.fecha_fin',
                        'e.estado',
                        'e.dirigido_a',
                        'pl.nombre',
                        'pl.tipo'
                    )
                    ->where('e.id', $idencuesta)
                    ->get();

                //si el usuario esta autentificado es admin le pasamos la lista del sidebar
                return view('admin.bienestar.encuestas.preguntasyrespuestas.index')
                    ->with('data', $result);
    }

    public function list(Request $request, $opcion)
    {
        if ($request->ajax()) {

            // Obtener todas las preguntas de la encuesta con sus opciones
            $preguntas = DB::table('preguntas as pr')
                ->select('pr.id', 'pr.encuesta_id', 'pr.contenido as pregunta', 'pr.tipo')
                ->where('pr.encuesta_id', $opcion)
                ->get();

            if ($preguntas->isEmpty()) {
                return response()->json([
                    "status" => false,
                    "mensaje" => 'Warning: No hay registros',
                    "data" => [],
                ]);
            }

            // Procesar las preguntas y agregar opciones si es necesario
            $result = $preguntas->map(function ($pregunta) {
                if (in_array($pregunta->tipo, ['opcion_unica', 'multiple'])) {
                    // Obtener opciones solo para preguntas de tipo 'unica' o 'multiple'
                    $opciones = DB::table('opciones_respuesta as opr')
                        ->where('opr.pregunta_id', $pregunta->id)
                        ->select('id', 'contenido')
                        ->get();

                    $pregunta->opciones = $opciones;
                } else {
                    $pregunta->opciones = []; // Sin opciones para preguntas de texto
                }

                return $pregunta;
            });


            return response()->json([
                "status" => true,
                "mensaje" => 'Success: la consulta tiene registros encontrados',
                "preguntas" => $preguntas,
                "opciones" => $result,
                "total_opciones"=> $this->list_totalesopciones($opcion),

            ]);
        }

        return response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los datos',
        ]);
    }


    public function list_totalesopciones($encuesta_id){

        $result_totalopciones= DB::table('preguntas')
            ->select('encuesta_id',
                DB::raw("SUM(tipo = 'texto') AS total_texto"),
                DB::raw("SUM(tipo = 'opcion_unica') AS total_opcion_unica"),
                DB::raw("SUM(tipo = 'multiple') AS total_multiple")
            )
            ->where('encuesta_id', $encuesta_id)
            ->groupBy('encuesta_id')
            ->get();

            return $result_totalopciones;

    }

    public function store(Request $request)
    {
        try {
            // Crear un nuevo objeto de Pregunta
            $pregunta = new Pregunta();
            $pregunta->encuesta_id = $request->input('id_encuesta_form');
            $pregunta->contenido = $request->input('text_pregunta');
            $pregunta->tipo = $request->input('txt-tiprespuesta');

            // Guardar la pregunta en la base de datos
            if ($pregunta->save()) {
                // Si la respuesta es de tipo texto, retornamos solo la encuesta
                if ($request->input('txt-tiprespuesta') == "texto") {
                    return response()->json([
                        "status" => true,
                        "mensaje" => '¡Éxito! Encuesta registrada.',
                        "data" => $pregunta, // Opcional: Devolver la Encuesta creada
                    ], 201); // Código 201 para creación exitosa
                } else if ($request->input('txt-tiprespuesta') == "opcion_unica") {
                    // Recoger las opciones (asegurándonos que se recoge como un array)
                    $opciones = $request->input('text_preguntaradio'); // Esto debería recoger el array de opciones

                    // Si las opciones no están vacías
                    if ($opciones && is_array($opciones)) {
                        // Aquí podrías guardar las opciones en la base de datos
                        foreach ($opciones as $opcion) {
                            OpcionRespuesta::create([
                                'pregunta_id' => $pregunta->id,  // Relacionar la opción con la pregunta
                                'contenido' => $opcion,               // Guardar el texto de la opción
                            ]);
                        }
                    }

                    return response()->json([
                        "status" => true,
                        'message' => 'Pregunta y opciones guardadas correctamente.',
                        "data" => $pregunta, // Devolver la pregunta
                        "opciones" => $opciones, // Devolver las opciones que se guardaron
                        "pregunta_id" => $pregunta->id // Devolver el ID de la pregunta creada
                    ], 201); // Código 201 para creación exitosa
                } else if ($request->input('txt-tiprespuesta') == "multiple") {
                    // Recoger las opciones (asegurándonos que se recoge como un array)
                    $opciones = $request->input('text_preguntacheck'); // Esto debería recoger el array de opciones

                    // Si las opciones no están vacías
                    if ($opciones && is_array($opciones)) {
                        // Aquí podrías guardar las opciones en la base de datos
                        foreach ($opciones as $opcion) {
                            OpcionRespuesta::create([
                                'pregunta_id' => $pregunta->id,  // Relacionar la opción con la pregunta
                                'contenido' => $opcion,               // Guardar el texto de la opción
                            ]);
                        }
                    }

                    return response()->json([
                        "status" => true,
                        'message' => 'Pregunta y opciones guardadas correctamente.',
                        "data" => $pregunta, // Devolver la pregunta
                        "opciones" => $opciones, // Devolver las opciones que se guardaron
                        "pregunta_id" => $pregunta->id // Devolver el ID de la pregunta creada
                    ], 201); // Código 201 para creación exitosa
                }
            }

            // Respuesta en caso de error al guardar
            return response()->json([
                "status" => false,
                "mensaje" => 'Error al registrar la Encuesta. Inténtalo nuevamente.',
                "data" => $pregunta,
            ], 500); // Código 500 para errores internos

        } catch (\Exception $e) {
            // Manejar excepciones inesperadas
            return response()->json([
                "status" => false,
                "mensaje" => 'Ocurrió un error inesperado.',
                "error" => $e->getMessage(), // Para debugging en desarrollo
            ], 500);
        }
    }


    public function update(Request $request, $PreuntaoOpcion, $idpreguntaoOpcion)
    {

        if ($PreuntaoOpcion == "pregunta") {
            $item = Pregunta::find($idpreguntaoOpcion);
        } else {
            $item = OpcionRespuesta::find($idpreguntaoOpcion);
        }

        if (!$item) {
            abort(404); // Manejo de error si no se encuentra el registro
        } else {

            $item->contenido = $request->input('text_opcionyopcion');

            if ($item->save()) {
                // El guardado fue exitoso
                return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
            } else {
                // El guardado falló
                return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
            }
        }
    }

    public function destroy($id)
    {
        // Busca el registro por su ID
        $pregunta = Pregunta::find($id);

        // Verifica si el registro existe
        if (!$pregunta) {
            return response()->json([
                "status" => false,
                "mensaje" => 'Error, el registro nos existe',
                "pregunta" => $pregunta,
                "id" => $id
            ]);
        }

        // Elimina el registro de la base de datos
        if ($pregunta->delete()) {
            return response()->json([
                "status" => true,
                "mensaje" => 'Éxito, la pregunta fue eliminada'
            ]);
        } else {
            return response()->json([
                "status" => false,
                "mensaje" => 'Error, al eliminar registro'
            ]);
        }
    }

    public function destroyOpcion($idpregunta, $idopcionrespuesta)
    {
        // Busca el registro por su ID

        $pregunta = OpcionRespuesta::find($idopcionrespuesta);

        // Verifica si el registro existe
        if (!$pregunta) {
            return response()->json([
                "status" => false,
                "mensaje" => 'Error, el registro nos existe',
                "pregunta" => $pregunta,
                "id" => $idopcionrespuesta
            ]);
        } else {
            $totalRegistros = OpcionRespuesta::where('pregunta_id', $idpregunta)->count();

            if ($totalRegistros > 2) {
                // Elimina el registro de la base de datos
                if ($pregunta->delete()) {
                    return response()->json([
                        "status" => true,
                        "mensaje" => 'Éxito, la pregunta fue eliminada'
                    ]);
                } else {
                    return response()->json([
                        "status" => false,
                        "mensaje" => 'Error, al eliminar registro'
                    ]);
                }
            } else {
                // Manejo de error si el total es menor a 2
                return response()->json([
                    'status' => false,
                    'mensaje' => 'La pregunta debe tener como minimo 2 opciones',
                ]);
            }
        }
    }
}
