<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;

use App\Http\Controllers\sidebar\SidebarController;
use App\Models\Appointmenttype;
use App\Models\Personalappointment;
use App\Models\Audit;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Yajra\DataTables\Facades\DataTables;
use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;
use Carbon\Carbon;

class PersonalAppointmentController extends Controller
{
    public function index(Request $request)
    {
        return view('admin.citas_presenciales.gestionar.index');
    }


    public function list(Request $request)
    {
        if ($request->ajax()) {
            $data = DB::table('citas_presenciales as cp')
                ->leftJoin('usuarios as u1', 'u1.id', '=', 'cp.user_id')
                ->leftJoin('usuarios as u2', 'u2.id', '=', 'cp.user2_id')
                ->select([
                    'u2.id as user2_id',
                    'cp.id as id',
                    'cp.nroidenti',
                    'cp.nombres',
                    'cp.apellido_pa',
                    'cp.apellido_ma',
                    'cp.email',
                    'cp.celular',
                    'cp.asunto',
                    'cp.datos_cita',
                    'cp.fecha',
                    DB::raw("DATE_FORMAT(cp.horaini, '%H:%i') AS horaini"),
                    DB::raw("DATE_FORMAT(cp.horafin, '%H:%i') AS horafin"),
                    // 'cp.horaini',
                    // 'cp.horafin',
                    DB::raw("CONCAT(DATE_FORMAT(cp.fecha, '%d/%m/%Y'), ' ', DATE_FORMAT(cp.horaini, '%H:%i')) AS fecha_hora"),
                    DB::raw("CONCAT(cp.apellido_pa, ' ', cp.apellido_ma, ' ', cp.nombres) AS usuario1"),
                    'cp.estado'
                ])
                ->orderBy('fecha_hora', 'desc')
                ->get();

            return \Yajra\DataTables\DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los archivos'
        ]);
    }


    public function store(Request $request)
    {
        $item = new Personalappointment();
        $item->nroidenti = $request->input('txt-nroidenti');
        $item->nombres = $request->input('txt-nombres');
        $item->apellido_pa = $request->input('txt-apellido_pa');
        $item->apellido_ma = $request->input('txt-apellido_ma');
        $item->email = $request->input('txt-email');
        $item->celular = $request->input('txt-celular');
        $item->asunto = $request->input('txt-asunto');
        $item->datos_cita = $request->input('txt-datos_cita');
        $item->fecha = $request->input('txt-fecha');
        $item->horaini = $request->input('txt-horaini');
        $item->user2_id = $request->input('txt-user2_id');
        $item->horafin = $request->input('txt-horafin');
        $item->estado = $request->input('txt-estado');
        // Asigna otros campos según tus necesidades

        // Guarda el nuevo registro en la base de datos
        if ($item->save()) {

            $this->auditoria($item->id, 'store');

            return response()->json(["status" => true, "mensaje" => 'Registro insertado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'Registro no insertado']);
        }
    }


    public function ajax_all(Request $request)
    {
        if ($request->ajax()) {
            $data = DB::table('convenios_efsrt as co')
            ->join('bt_empresas as em', 'co.company_id', '=', 'em.id')
            ->select(
                'co.id as idagreement',
                'co.company_id as idcompany',
                'co.fecha_inicio',
                'co.fecha_fin',
                'co.descripcion',
                DB::raw('CONCAT(em.ruc, " - ", em.nombre) as empresa')
            )
            ->get();

            return response()->json($data);
        }
        return  response()->json([
            "status" => false,
            "mensaje" => 'Error en request'
        ]);
    }


    public function update(Request $request, $id)
    {
        $item = Personalappointment::find($id);

        if (!$item) {
            abort(404); // Manejo de error si no se encuentra el registro
        } else {
            $item->nroidenti = $request->input('txt-nroidenti');
            $item->nombres = $request->input('txt-nombres');
            $item->apellido_pa = $request->input('txt-apellido_pa');
            $item->apellido_ma = $request->input('txt-apellido_ma');
            $item->email = $request->input('txt-email');
            $item->celular = $request->input('txt-celular');
            $item->asunto = $request->input('txt-asunto');
            $item->datos_cita = $request->input('txt-datos_cita');
            $item->fecha = $request->input('txt-fecha');
            $item->horaini = $request->input('txt-horaini');
            $item->user2_id = $request->input('txt-user2_id');
            $item->horafin = $request->input('txt-horafin');
            $item->estado = $request->input('txt-estado');

            if ($item->save()) {

                $this->auditoria($item->id, 'update');

                return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
            }
        }
    }


    public function destroy($id)
    {
        // Busca el registro por su ID
        $item = Personalappointment::find($id);

        // Verifica si el registro existe
        if (!$item) {
            return response()->json(["status" => false, "mensaje" => 'El registro no existe']);
        }

        $this->auditoria($id, 'delete');

        // Elimina el registro de la base de datos
        if ($item->delete()) {
            return response()->json(["status" => true, "mensaje" => 'El registro fue eliminado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'El registro no fue eliminado']);
        }
    }


    public function auditoria($id, $funcion) {

        $item = Personalappointment::find($id);

        $user = User::where('id', $item->user2_id)->first();

        $auditoria = new Audit();
        $auditoria->user_id = Auth::User()->id;
        $auditoria->tabla_id = $item->id;
        $auditoria->tabla_modelo = "Personalappointment";
        $auditoria->tabla_nombre = "citas_presenciales";
        $auditoria->accion = $funcion;
        $auditoria->fecha_hora = now();
        $informacion =  "ID: " . $item->id . "\n" .
                        "Nro DNI: " . $item->nroidenti . "\n" .
                        "Nombres: " . $item->nombres . "\n" .
                        "Apellido Paterno: " . $item->apellido_pa . "\n" .
                        "Apellido Materno: " . $item->apellido_ma . "\n" .
                        "Correo: " . $item->email . "\n" .
                        "Celular: " . $item->celular . "\n" .
                        "Tramite: " . $item->datos_cita . "\n" .
                        "Asunto: " . $item->asunto . "\n" .
                        "Fecha: " . $item->fecha . "\n" .
                        "Hora Inicio: " . $item->horaini . "\n" .
                        "DNI del que Atiende: " . $user->nroidenti .  "\n" .
                        "Nombres del que Atiende: " . $user->nombres . $user->apellido_pa . $user->apellido_ma;
        $auditoria->informacion = $informacion;
        $auditoria->save();
    }
}
