<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;

use App\Http\Controllers\sidebar\SidebarController;
use App\Models\Permission;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Yajra\DataTables\Facades\DataTables;

class PermissionController extends Controller
{
    //
    public function index(Request $request)
    {
        return view('admin.seguridad.permisos.index');
    }



    public function list(Request $request)
    {
        if ($request->ajax()) {
            $data = Permission::join('modulos AS m', 'permisos.module_id', '=', 'm.id')
                ->join('roles AS r', 'permisos.role_id', '=', 'r.id')
                ->where('r.id', '!=', 1)
                ->orderBy('r.id', 'asc')
                ->get([
                    'permisos.id AS idpermiso',
                    'r.id AS idrol',
                    'r.nombre AS rol',
                    'r.descripcion AS descripcion',
                    'm.id AS idmodulo',
                    'm.nombre AS modulo',
                    'm.icon',
                    'permisos.estado AS permiso',
                    'permisos.create',
                    'permisos.read',
                    'permisos.update',
                    'permisos.delete',
                ]);

            return DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los archivos'
        ]);
    }


    public function ajax_all(Request $request)
    {
        if ($request->ajax()) {
            $data = Permission::all();
            return response()->json($data);
        }
        return  response()->json([
            "status" => false,
            "mensaje" => 'Error en request'
        ]);
    }


    public function update(Request $request, $idrol, $idmodulo)
    {
        //
        $validator = Validator::make($request->all(), [
            'txt_permiso_name' => 'required',
        ]);
        
        if ($validator->fails()) {
            return response()->json([
                "status" => false,
                "mensaje" => $validator->errors()
            ]);
        }
        
        //$item = Permission::find($idrol, $idmodulo);
        $item = Permission::where('role_id', $idrol)
            ->where('module_id', $idmodulo)
            ->first();
            
            if (!$item) {
            abort(404); // Manejo de error si no se encuentra el registro
        } else {
            $item->estado = $request->input('txt_permiso_name');
            
            if ($item->save()) {
                // El guardado fue exitoso
                return response()->json([
                    "status" => true,
                    "mensaje" => 'Permiso actualizado'
                ]);
            } else {
                // El guardado falló
                return response()->json([
                    "status" => false,
                    "mensaje" => 'El permiso no pudo ser actualizado'
                ]);
            }
        }
    }


    public function update_accion(Request $request, $idpermiso)
    {
        //
        $validator = Validator::make($request->all(), [
            'txt-action' => 'required',
            'txt-action_new_value' => 'required',
        ]);
        
        if ($validator->fails()) {
            return response()->json([
                "status" => false,
                "mensaje" => $validator->errors()
            ]);
        }
        
        //$item = Permission::find($idrol, $idmodulo);
        $item = Permission::where('id', $idpermiso)
            ->first();
        
        if (!$item) {
            abort(404); // Manejo de error si no se encuentra el registro
        } else {
            $action = $request->input('txt-action');
            $item->$action = $request->input('txt-action_new_value');
            
            if ($item->save()) {
                // El guardado fue exitoso
                return response()->json([
                    "status" => true,
                    "mensaje" => "Permiso ($action) actualizado"
                ]);
            } else {
                // El guardado falló
                return response()->json([
                    "status" => false,
                    "mensaje" => "El permiso ($action) no pudo ser actualizado"
                ]);
            }
        }
    }
}
