<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;

use App\Http\Controllers\sidebar\SidebarController;
use App\Models\Medicalappointment;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;

class MedicalappointmentController extends Controller
{
    public function index(Request $request)
    {
        return view('admin.centro_medico.citas.index');
    }


    public function list(Request $request)
    {
        if ($request->ajax()) {
            $data = DB::table('citas_medicas AS ci')
                ->select([
                    'ci.id AS idappointment',
                    'us1.id AS idpatient',
                    'us2.id AS idspecialist',
                    'tci.id AS idappointmenttype',
                    'tci.nombre AS tipo_cita',
                    'au.id AS idclassroom',
                    'ci.descripcion',
                    'ci.fecha',
                    DB::raw('DATE_FORMAT(ci.hora_ini, "%H:%i") AS hora_ini'),
                    DB::raw('DATE_FORMAT(ci.hora_fin, "%H:%i") AS hora_fin'),
                    DB::raw("CONCAT(au.tipo, ' - ', au.numero) AS ambiente"),
                    DB::raw("CONCAT(DATE_FORMAT(ci.hora_ini, '%H:%i'), ' a ', DATE_FORMAT(ci.hora_fin, '%H:%i'), ' - ', DATE_FORMAT(ci.fecha, '%d/%m/%Y')) AS fecha_hora"),
                    DB::raw("CONCAT(us1.apellido_pa, ' ', us1.apellido_ma, ' ,', us1.nombres) AS paciente"),
                    DB::raw("CONCAT(us2.apellido_pa, ' ', us2.apellido_ma, ' ,', us2.nombres) AS especialista"),
                    'ci.estado_cita',
                    'ci.motivo_cancelacion',
                    'ci.diagnostico',
                    'ci.tratamiento',
                    'ci.observacion',
                    'ci.estado_atencion',
                ])
                ->join('tipos_citas AS tci', 'tci.id', '=', 'ci.appointment_type_id')
                ->join('usuarios AS us1', 'us1.id', '=', 'ci.patient_id')
                ->join('usuarios AS us2', 'us2.id', '=', 'ci.specialist_id')
                ->join('tipos_identificaciones AS ti1', 'ti1.id', '=', 'us1.identificationtype_id')
                ->join('tipos_identificaciones AS ti2', 'ti2.id', '=', 'us2.identificationtype_id')
                ->join('aulas AS au', 'au.id', '=', 'ci.classroom_id')
                ->orderByRaw('DATE(ci.fecha) DESC, TIME(ci.hora_ini) ASC, tci.nombre')
            ->get();


            return \Yajra\DataTables\DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los archivos'
        ]);
    }


    public function store(Request $request)
    {
        $item = new Medicalappointment();
        $item->patient_id = $request->input('txt-patient_id');
        $item->specialist_id = $request->input('txt-specialist_id');
        $item->appointment_type_id = $request->input('txt-appointment_type_id');
        $item->classroom_id = $request->input('txt-classroom_id');
        $item->fecha = $request->input('txt-fecha');
        $item->hora_ini = $request->input('txt-hora_ini');
        $item->hora_fin = $request->input('txt-hora_fin');
        $item->descripcion = $request->input('txt-descripcion');
        $item->motivo_cancelacion = $request->input('txt-motivo_cancelacion');
        $item->estado_cita = $request->input('txt-estado_cita');
        // Asigna otros campos según tus necesidades

        // Guarda el nuevo registro en la base de datos
        if ($item->save()) {
            return response()->json(["status" => true, "mensaje" => 'Registro insertado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'Registro no insertado']);
        }
    }


    public function ajax_all(Request $request)
    {
        if ($request->ajax()) {
            $data = Medicalappointment::all();
            return response()->json($data);
        }
        return  response()->json([
            "status" => false,
            "mensaje" => 'Error en request'
        ]);
    }


    public function update(Request $request, $id)
    {
        $item = Medicalappointment::find($id);

        if (!$item) {
            abort(404); // Manejo de error si no se encuentra el registro
        } else {
            $item->patient_id = $request->input('txt-patient_id');
            $item->specialist_id = $request->input('txt-specialist_id');
            $item->appointment_type_id = $request->input('txt-appointment_type_id');
            $item->classroom_id = $request->input('txt-classroom_id');
            $item->fecha = $request->input('txt-fecha');
            $item->hora_ini = $request->input('txt-hora_ini');
            $item->hora_fin = $request->input('txt-hora_fin');
            $item->descripcion = $request->input('txt-descripcion');
            $item->motivo_cancelacion = $request->input('txt-motivo_cancelacion');
            $item->estado_cita = $request->input('txt-estado_cita');

            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
            }
        }
    }

    public function update_attention(Request $request, $id)
    {
        $item = Medicalappointment::find($id);

        if (!$item) {
            abort(404); // Manejo de error si no se encuentra el registro
        } else {
            $item->diagnostico = $request->input('txt-diagnostico');
            $item->tratamiento = $request->input('txt-tratamiento');
            $item->observacion = $request->input('txt-observacion');
            $item->estado_atencion = $request->input('txt-estado_atencion');

            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
            }
        }
    }

    public function destroy($id)
    {
        // Busca el registro por su ID
        $item = Medicalappointment::find($id);

        // Verifica si el registro existe
        if (!$item) {
            return response()->json(["status" => false, "mensaje" => 'El registro no existe']);
        }

        // Elimina el registro de la base de datos
        if ($item->delete()) {
            return response()->json(["status" => true, "mensaje" => 'El registro fue eliminado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'El registro no fue eliminado']);
        }
    }
}
