<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;

use App\Http\Controllers\sidebar\SidebarController;
use App\Models\Jpjob;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Yajra\DataTables\Facades\DataTables;

class JpjobController extends Controller
{


    public function index(Request $request)
    {
        return view('admin.bolsa_laboral.ofertas_laborales.index');
    }

    public function list(Request $request)
    {
        if ($request->ajax()) {
            // query
            $data = DB::table('bt_trabajos as job')
                ->join('bt_empresas as com', 'job.jpcompany_id', '=', 'com.id')
                ->join('bt_categorias as cat', 'job.jpcategory_id', '=', 'cat.id')
                ->join('ubigeos as ubi', 'job.ubigeo_id', '=', 'ubi.id')
                ->select(
                    'job.id as idjob',
                    'job.puesto',
                    'job.vacantes',
                    'job.tipo',
                    'job.modalidad',
                    'job.experiencia',
                    'job.fecpublicacion',
                    'job.feccierre',
                    'job.salariomin',
                    'job.salariomax',
                    'job.nivel_educativo',
                    'job.descripcion',
                    'job.estado',
                    'com.id as idcompany',
                    'com.nombre as nombrecompany',
                    'cat.id as idcategory',
                    'cat.nombre as nombrecategory',
                    'ubi.id as idubigeo',
                    DB::raw('SUBSTRING(ubi.id, 1, 2) as iddepartamento'),
                    'ubi.departamento',
                    DB::raw('SUBSTRING(ubi.id, 3, 2) as idprovincia'),
                    'ubi.provincia',
                    DB::raw('SUBSTRING(ubi.id, 5, 2) as iddistrito'),
                    'ubi.distrito',
                    DB::raw('CASE
                        WHEN job.feccierre < CURDATE() THEN "0"
                        ELSE "1"
                        END as estado_actual'
                    )
                )
                ->orderBy('job.fecpublicacion','desc')
                ->get();
            // datatable
            return DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }

        return  response()->json(["status" => false, "mensaje" => 'No se puede cargar la información']);
    }


    public function store(Request $request)
    {
        // nuevo objeto
        $item = new Jpjob();
        $item->jpcompany_id = $request->input('txt-companies');
        $item->jpcategory_id = $request->input('txt-categories');
        $item->puesto = $request->input('txt-puesto');
        $item->vacantes = $request->input('txt-vacantes');
        $item->tipo = $request->input('txt-tipo');
        $item->modalidad = $request->input('txt-modalidad');
        $item->experiencia = $request->input('txt-experiencia');
        $item->nivel_educativo = $request->input('txt-nivel_educativo');
        $item->fecpublicacion = $request->input('txt-fecpublicacion');
        $item->feccierre = $request->input('txt-feccierre');
        $item->salariomin = $request->input('txt-salariomin');
        $item->salariomax = $request->input('txt-salariomax');
        $item->estado = $request->input('txt-estado');
        $idubigeo = $request->input('txt_departamento') . $request->input('txt_provincia') . $request->input('txt_distrito');
        $item->ubigeo_id = $idubigeo;
        $item->link = $request->input('txt-link');
        $item->descripcion = $request->input('descripcion');

        if($item->fecpublicacion > $item->feccierre){
            return response()->json(["status" => false, "mensaje" => 'La fecha de Publicacion es mayor a la fecha de cierre']);
        }

        // validar guardado
        if ($item->save()) {
            return response()->json(["status" => true, "mensaje" => 'Registro insertado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'Registro no insertado']);
        }
    }


    public function update(Request $request, $id)
    {
        $item = Jpjob::find($id);

        // validar existencia del registro
        if (!$item) {
            abort(404);
        } else {
            if($request->input('descripcion')){}
            // recoger datos
            $item->jpcompany_id = $request->input('txt-companies');
            $item->jpcategory_id = $request->input('txt-categories');
            $item->puesto = $request->input('txt-puesto');
            $item->vacantes = $request->input('txt-vacantes');
            $item->tipo = $request->input('txt-tipo');
            $item->modalidad = $request->input('txt-modalidad');
            $item->experiencia = $request->input('txt-experiencia');
            $item->nivel_educativo = $request->input('txt-nivel_educativo');
            $item->fecpublicacion = $request->input('txt-fecpublicacion');
            $item->feccierre = $request->input('txt-feccierre');
            $item->salariomin = $request->input('txt-salariomin');
            $item->salariomax = $request->input('txt-salariomax');
            $item->estado = $request->input('txt-estado');
            $idubigeo = $request->input('txt_departamento') . $request->input('txt_provincia') . $request->input('txt_distrito');
            $item->ubigeo_id = $idubigeo;
            $item->link = $request->input('txt-link');
            $item->descripcion = $request->input('descripcion');

            if($item->fecpublicacion > $item->feccierre){
                return response()->json(["status" => false, "mensaje" => 'La fecha de Publicacion es mayor a la fecha de cierre']);
            }

            // validar guardado
            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
            }
        }
    }


    public function destroy($id)
    {
        $item = Jpjob::find($id);

        // validar existencia del registro
        if (!$item) {
            return response()->json(["status" => false, "mensaje" => 'El registro no existe']);
        }

        // validar eliminación
        if ($item->delete()) {
            return response()->json(["status" => true, "mensaje" => 'El registro fue eliminado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'El registro no fue eliminado']);
        }
    }
}
