<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Models\Jpcompany;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use Yajra\DataTables\Facades\DataTables;

class JpcompanyController extends Controller
{
    //

    public function index(Request $request)
    {
        return view('admin.bolsa_laboral.empresas.index');
    }

    public function list(Request $request)
    {
        if ($request->ajax()) {
            // query
            $data = DB::table('bt_empresas')
                ->select('id', 'nombre', 'ruc', 'direccion', 'nrocontacto', 'estado', 'user', 'logo')
                ->get();

            // datatable
            return DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }

        return response()->json(['status' => false, 'mensaje' => 'No se puede cargar la información']);
    }

    public function store(Request $request)
    {
        // nuevo objeto
        $item = new Jpcompany();
        $item->nombre = $request->input('txt-nombre');
        $item->ruc = $request->input('txt-ruc');
        $item->direccion = $request->input('txt-direccion');
        $item->nrocontacto = $request->input('txt-nrocontacto');
        $item->estado = $request->input('txt-activo');
        $item->user = $request->input('txt-user');
        $item->password = $request->input('txt-password');
        $item->logo = '--';
        // $item->logo = $request->input('txt-logo');

        // validar guardado
        if ($item->save()) {
            return response()->json(['status' => true, 'mensaje' => 'Registro insertado']);
        } else {
            return response()->json(['status' => false, 'mensaje' => 'Registro no insertado']);
        }
    }

    public function update(Request $request, $id)
    {
        $item = Jpcompany::find($id);

        // validar existencia del registro
        if (! $item) {
            abort(404);
        } else {
            // recoger datos
            $item->nombre = $request->input('txt-nombre');
            $item->ruc = $request->input('txt-ruc');
            $item->direccion = $request->input('txt-direccion');
            $item->nrocontacto = $request->input('txt-nrocontacto');
            $item->estado = $request->input('txt-activo');
            $item->user = $request->input('txt-user');
            $item->logo = '--';
            // validar guardado
            if ($item->save()) {
                return response()->json(['status' => true, 'mensaje' => 'Registro actualizado']);
            } else {
                return response()->json(['status' => false, 'mensaje' => 'Registro no actualizado']);
            }
        }
    }

    public function update_password(Request $request, $id)
    {

        // $validator = Validator::make($request->all(), [
        //     'text_codigo_programa_name' => 'required|min:5',
        //     'text_name_programa_name' => 'required',
        //     'nivel_formativo' => 'required'
        // ]);

        // if ($validator->fails()) {
        //     return response()->json([
        //         "status" => false,
        //         "mensaje" => $validator->errors()
        //     ]);
        // }

        $item = Jpcompany::find($id);

        // validar existencia del registro
        if (! $item) {
            abort(404);
        } else {
            // recoger datos
            $item->password = $request->input('txt_password2');
            // validar guardado
            if ($item->save()) {
                return response()->json(['status' => true, 'mensaje' => 'Registro actualizado']);
            } else {
                return response()->json(['status' => false, 'mensaje' => 'Registro no actualizado']);
            }
        }
    }

    public function destroy($id)
    {
        $item = Jpcompany::find($id);

        // validar existencia del registro
        if (! $item) {
            return response()->json(['status' => false, 'mensaje' => 'El registro no existe']);
        }

        // validar eliminación
        if ($item->delete()) {
            return response()->json(['status' => true, 'mensaje' => 'El registro fue eliminado']);
        } else {
            return response()->json(['status' => false, 'mensaje' => 'El registro no fue eliminado']);
        }
    }

    public function query_data($nroruc)
    {
        $token = 'apis-token-6194.hK3hbzBDyBDl6XqMq1idxOEs8zNDv6AJ';

        // Iniciar llamada a API
        $curl = curl_init();

        // Buscar ruc sunat
        curl_setopt_array($curl, [
            // para usar la versión 2
            CURLOPT_URL => 'https://api.apis.net.pe/v1/ruc?numero='.$nroruc,
            // para usar la versión 1
            // CURLOPT_URL => 'https://api.apis.net.pe/v1/ruc?numero=' . $ruc,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_SSL_VERIFYPEER => 0,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => [
                'Referer: http://apis.net.pe/api-ruc',
                'Authorization: Bearer '.$token,
            ],
        ]);

        $response = curl_exec($curl);

        curl_close($curl);
        // Datos de empresas según padron reducido

        return response()->json([
            'status' => true,
            'mensaje' => 'Consulta realizada',
            'data' => $response,
        ]);
    }

    public function ajax_all(Request $request)
    {
        if ($request->ajax()) {
            // $data = Teacher::all();
            $data = DB::table('bt_empresas as jc')
                ->select(
                    'jc.id as idcompany',
                    'jc.nombre',
                    'jc.ruc',
                    'jc.direccion',
                    'jc.nrocontacto',
                    'jc.estado',
                    'jc.user',
                    'jc.logo',
                )
                ->orderBy('jc.nombre', 'asc')
                ->get();

            return response()->json($data);
        }

        return response()->json(['status' => false, 'mensaje' => 'Error en request']);
    }
}
