<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;

use App\Http\Controllers\sidebar\SidebarController;
use App\Models\ExternalValidation;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;
use App\Models\Institution;

class InstitutionController extends Controller
{

    public function index(Request $request)
    {
        return view('admin.institucion.instituciones.index');
    }


    public function list(Request $request)
    {
        if ($request->ajax()) {
            $data = Institution::select([
                'id',
                'name',
                'direccion',
                'contact_number',
                'email',
            ])
                ->get();

            return \Yajra\DataTables\DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los archivos'
        ]);
    }


    public function store(Request $request)
    {
        $item = new Institution();
        $item->name               = $request->input('txt-name');
        $item->direccion            = $request->input('txt-direccion');
        $item->contact_number             = $request->input('txt-contact_number');
        $item->email               = $request->input('txt-email');
        // Asigna otros campos según tus necesidades

        // Guarda el nuevo registro en la base de datos
        if ($item->save()) {
            return response()->json(["status" => true, "mensaje" => 'Registro insertado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'Registro no insertado']);
        }
    }

    public function ajax_all(Request $request)
    {
        if ($request->ajax()) {
            $data = Institution::all();
            return response()->json($data);
        }
        return  response()->json([
            "status" => false,
            "mensaje" => 'Error en request'
        ]);
    }


    public function update(Request $request, $id)
    {
        $item = Institution::find($id);

        if (!$item) {
            abort(404); // Manejo de error si no se encuentra el registro
        } else {
            $item->name               = $request->input('txt-name');
            $item->direccion            = $request->input('txt-direccion');
            $item->contact_number             = $request->input('txt-contact_number');
            $item->email               = $request->input('txt-email');

            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
            }
        }
    }


    public function destroy($id)
    {
        // 1) Verificar existencia
        $campus = Institution::find($id);
        if (!$campus) {
            return response()->json(["status" => false, "mensaje" => "El registro no existe"]);
        }

        // 2) Verificar aulas asociadas (más eficiente con exists)
        $hasClassrooms = ExternalValidation::where('institucion_id', $campus->id)->exists();
        if ($hasClassrooms) {
            return response()->json([
                "status" => false,
                "mensaje" => "No se puede eliminar la sede porque tiene aulas asociadas"
            ]);
        }

        // 3) Eliminar
        $deleted = $campus->delete();
        return response()->json([
            "status" => (bool) $deleted,
            "mensaje" => $deleted ? "El registro fue eliminado" : "El registro no fue eliminado"
        ]);
    }
}
